package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEciScalingConfiguration invokes the ess.CreateEciScalingConfiguration API synchronously
func (client *Client) CreateEciScalingConfiguration(request *CreateEciScalingConfigurationRequest) (response *CreateEciScalingConfigurationResponse, err error) {
	response = CreateCreateEciScalingConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEciScalingConfigurationWithChan invokes the ess.CreateEciScalingConfiguration API asynchronously
func (client *Client) CreateEciScalingConfigurationWithChan(request *CreateEciScalingConfigurationRequest) (<-chan *CreateEciScalingConfigurationResponse, <-chan error) {
	responseChan := make(chan *CreateEciScalingConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEciScalingConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEciScalingConfigurationWithCallback invokes the ess.CreateEciScalingConfiguration API asynchronously
func (client *Client) CreateEciScalingConfigurationWithCallback(request *CreateEciScalingConfigurationRequest, callback func(response *CreateEciScalingConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEciScalingConfigurationResponse
		var err error
		defer close(result)
		response, err = client.CreateEciScalingConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEciScalingConfigurationRequest is the request struct for api CreateEciScalingConfiguration
type CreateEciScalingConfigurationRequest struct {
	*requests.RpcRequest
	Container                     *[]CreateEciScalingConfigurationContainer               `position:"Query" name:"Container"  type:"Repeated"`
	NtpServer                     *[]string                                               `position:"Query" name:"NtpServer"  type:"Repeated"`
	SpotPriceLimit                requests.Float                                          `position:"Query" name:"SpotPriceLimit"`
	EnableSls                     requests.Boolean                                        `position:"Query" name:"EnableSls"`
	ResourceGroupId               string                                                  `position:"Query" name:"ResourceGroupId"`
	HostName                      string                                                  `position:"Query" name:"HostName"`
	ActiveDeadlineSeconds         requests.Integer                                        `position:"Query" name:"ActiveDeadlineSeconds"`
	EgressBandwidth               requests.Integer                                        `position:"Query" name:"EgressBandwidth"`
	DnsConfigSearch               *[]string                                               `position:"Query" name:"DnsConfigSearch"  type:"Repeated"`
	HostAliase                    *[]CreateEciScalingConfigurationHostAliase              `position:"Query" name:"HostAliase"  type:"Repeated"`
	ImageSnapshotId               string                                                  `position:"Query" name:"ImageSnapshotId"`
	Tag                           *[]CreateEciScalingConfigurationTag                     `position:"Query" name:"Tag"  type:"Repeated"`
	CpuOptionsThreadsPerCore      requests.Integer                                        `position:"Query" name:"CpuOptionsThreadsPerCore"`
	DataCachePL                   string                                                  `position:"Query" name:"DataCachePL"`
	Ipv6AddressCount              requests.Integer                                        `position:"Query" name:"Ipv6AddressCount"`
	Cpu                           requests.Float                                          `position:"Query" name:"Cpu"`
	OwnerId                       requests.Integer                                        `position:"Query" name:"OwnerId"`
	ScalingConfigurationName      string                                                  `position:"Query" name:"ScalingConfigurationName"`
	SpotStrategy                  string                                                  `position:"Query" name:"SpotStrategy"`
	Volume                        *[]CreateEciScalingConfigurationVolume                  `position:"Query" name:"Volume"  type:"Repeated"`
	InstanceFamilyLevel           string                                                  `position:"Query" name:"InstanceFamilyLevel"`
	DnsConfigOption               *[]CreateEciScalingConfigurationDnsConfigOption         `position:"Query" name:"DnsConfigOption"  type:"Repeated"`
	EphemeralStorage              requests.Integer                                        `position:"Query" name:"EphemeralStorage"`
	DataCacheProvisionedIops      requests.Integer                                        `position:"Query" name:"DataCacheProvisionedIops"`
	EipBandwidth                  requests.Integer                                        `position:"Query" name:"EipBandwidth"`
	GpuDriverVersion              string                                                  `position:"Query" name:"GpuDriverVersion"`
	CostOptimization              requests.Boolean                                        `position:"Query" name:"CostOptimization"`
	DataCacheBurstingEnabled      requests.Boolean                                        `position:"Query" name:"DataCacheBurstingEnabled"`
	Memory                        requests.Float                                          `position:"Query" name:"Memory"`
	ScalingGroupId                string                                                  `position:"Query" name:"ScalingGroupId"`
	SecurityGroupId               string                                                  `position:"Query" name:"SecurityGroupId"`
	Description                   string                                                  `position:"Query" name:"Description"`
	IngressBandwidth              requests.Integer                                        `position:"Query" name:"IngressBandwidth"`
	DnsPolicy                     string                                                  `position:"Query" name:"DnsPolicy"`
	SecurityContextSysctl         *[]CreateEciScalingConfigurationSecurityContextSysctl   `position:"Query" name:"SecurityContextSysctl"  type:"Repeated"`
	DataCacheBucket               string                                                  `position:"Query" name:"DataCacheBucket"`
	DnsConfigNameServer           *[]string                                               `position:"Query" name:"DnsConfigNameServer"  type:"Repeated"`
	InitContainer                 *[]CreateEciScalingConfigurationInitContainer           `position:"Query" name:"InitContainer"  type:"Repeated"`
	InstanceType                  *[]string                                               `position:"Query" name:"InstanceType"  type:"Repeated"`
	TerminationGracePeriodSeconds requests.Integer                                        `position:"Query" name:"TerminationGracePeriodSeconds"`
	ImageRegistryCredential       *[]CreateEciScalingConfigurationImageRegistryCredential `position:"Query" name:"ImageRegistryCredential"  type:"Repeated"`
	ResourceOwnerAccount          string                                                  `position:"Query" name:"ResourceOwnerAccount"`
	RestartPolicy                 string                                                  `position:"Query" name:"RestartPolicy"`
	CpuOptionsCore                requests.Integer                                        `position:"Query" name:"CpuOptionsCore"`
	RamRoleName                   string                                                  `position:"Query" name:"RamRoleName"`
	AcrRegistryInfo               *[]CreateEciScalingConfigurationAcrRegistryInfo         `position:"Query" name:"AcrRegistryInfo"  type:"Repeated"`
	AutoMatchImageCache           requests.Boolean                                        `position:"Query" name:"AutoMatchImageCache"`
	LoadBalancerWeight            requests.Integer                                        `position:"Query" name:"LoadBalancerWeight"`
	ContainerGroupName            string                                                  `position:"Query" name:"ContainerGroupName"`
	AutoCreateEip                 requests.Boolean                                        `position:"Query" name:"AutoCreateEip"`
}

// CreateEciScalingConfigurationContainer is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationContainer struct {
	Stdin                                  string                                                  `name:"Stdin"`
	LivenessProbeExecCommand               *[]string                                               `name:"LivenessProbe.Exec.Command" type:"Repeated"`
	LifecyclePostStartHandlerHttpGetPort   string                                                  `name:"LifecyclePostStartHandlerHttpGetPort"`
	WorkingDir                             string                                                  `name:"WorkingDir"`
	ReadinessProbeHttpGetPort              string                                                  `name:"ReadinessProbe.HttpGet.Port"`
	LivenessProbeHttpGetPort               string                                                  `name:"LivenessProbe.HttpGet.Port"`
	LifecyclePreStopHandlerTcpSocketPort   string                                                  `name:"LifecyclePreStopHandlerTcpSocketPort"`
	VolumeMount                            *[]CreateEciScalingConfigurationContainerVolumeMount    `name:"VolumeMount" type:"Repeated"`
	Image                                  string                                                  `name:"Image"`
	LifecyclePostStartHandlerExec          *[]string                                               `name:"LifecyclePostStartHandlerExec" type:"Repeated"`
	Cpu                                    string                                                  `name:"Cpu"`
	ReadinessProbeHttpGetPath              string                                                  `name:"ReadinessProbe.HttpGet.Path"`
	Gpu                                    string                                                  `name:"Gpu"`
	StdinOnce                              string                                                  `name:"StdinOnce"`
	LifecyclePostStartHandlerTcpSocketHost string                                                  `name:"LifecyclePostStartHandlerTcpSocketHost"`
	LivenessProbeSuccessThreshold          string                                                  `name:"LivenessProbe.SuccessThreshold"`
	SecurityContextRunAsUser               string                                                  `name:"SecurityContext.RunAsUser"`
	LivenessProbePeriodSeconds             string                                                  `name:"LivenessProbe.PeriodSeconds"`
	LivenessProbeInitialDelaySeconds       string                                                  `name:"LivenessProbe.InitialDelaySeconds"`
	Port                                   *[]CreateEciScalingConfigurationContainerPort           `name:"Port" type:"Repeated"`
	Name                                   string                                                  `name:"Name"`
	LifecyclePreStopHandlerTcpSocketHost   string                                                  `name:"LifecyclePreStopHandlerTcpSocketHost"`
	SecurityContextReadOnlyRootFilesystem  string                                                  `name:"SecurityContext.ReadOnlyRootFilesystem"`
	LifecyclePreStopHandlerHttpGetHost     string                                                  `name:"LifecyclePreStopHandlerHttpGetHost"`
	Memory                                 string                                                  `name:"Memory"`
	LifecyclePreStopHandlerHttpGetScheme   string                                                  `name:"LifecyclePreStopHandlerHttpGetScheme"`
	LifecyclePostStartHandlerTcpSocketPort string                                                  `name:"LifecyclePostStartHandlerTcpSocketPort"`
	LifecyclePreStopHandlerHttpGetPath     string                                                  `name:"LifecyclePreStopHandlerHttpGetPath"`
	LifecyclePostStartHandlerHttpGetHost   string                                                  `name:"LifecyclePostStartHandlerHttpGetHost"`
	ReadinessProbeFailureThreshold         string                                                  `name:"ReadinessProbe.FailureThreshold"`
	Arg                                    *[]string                                               `name:"Arg" type:"Repeated"`
	ReadinessProbeSuccessThreshold         string                                                  `name:"ReadinessProbe.SuccessThreshold"`
	LifecyclePostStartHandlerHttpGetPath   string                                                  `name:"LifecyclePostStartHandlerHttpGetPath"`
	LifecyclePreStopHandlerExec            *[]string                                               `name:"LifecyclePreStopHandlerExec" type:"Repeated"`
	SecurityContextCapabilityAdd           *[]string                                               `name:"SecurityContext.Capability.Add" type:"Repeated"`
	ReadinessProbeInitialDelaySeconds      string                                                  `name:"ReadinessProbe.InitialDelaySeconds"`
	ReadinessProbeExecCommand              *[]string                                               `name:"ReadinessProbe.Exec.Command" type:"Repeated"`
	ReadinessProbeHttpGetScheme            string                                                  `name:"ReadinessProbe.HttpGet.Scheme"`
	LifecyclePreStopHandlerHttpGetPort     string                                                  `name:"LifecyclePreStopHandlerHttpGetPort"`
	ImagePullPolicy                        string                                                  `name:"ImagePullPolicy"`
	Command                                *[]string                                               `name:"Command" type:"Repeated"`
	LivenessProbeHttpGetPath               string                                                  `name:"LivenessProbe.HttpGet.Path"`
	LifecyclePostStartHandlerHttpGetScheme string                                                  `name:"LifecyclePostStartHandlerHttpGetScheme"`
	LivenessProbeTimeoutSeconds            string                                                  `name:"LivenessProbe.TimeoutSeconds"`
	LivenessProbeTcpSocketPort             string                                                  `name:"LivenessProbe.TcpSocket.Port"`
	ReadinessProbePeriodSeconds            string                                                  `name:"ReadinessProbe.PeriodSeconds"`
	EnvironmentVar                         *[]CreateEciScalingConfigurationContainerEnvironmentVar `name:"EnvironmentVar" type:"Repeated"`
	Tty                                    string                                                  `name:"Tty"`
	LivenessProbeFailureThreshold          string                                                  `name:"LivenessProbe.FailureThreshold"`
	ReadinessProbeTimeoutSeconds           string                                                  `name:"ReadinessProbe.TimeoutSeconds"`
	ReadinessProbeTcpSocketPort            string                                                  `name:"ReadinessProbe.TcpSocket.Port"`
	LivenessProbeHttpGetScheme             string                                                  `name:"LivenessProbe.HttpGet.Scheme"`
}

// CreateEciScalingConfigurationHostAliase is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationHostAliase struct {
	Hostname *[]string `name:"Hostname" type:"Repeated"`
	Ip       string    `name:"Ip"`
}

// CreateEciScalingConfigurationTag is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateEciScalingConfigurationVolume is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationVolume struct {
	DiskVolumeFsType                 string                                                                 `name:"DiskVolume.FsType"`
	EmptyDirVolumeSizeLimit          string                                                                 `name:"EmptyDirVolume.SizeLimit"`
	NFSVolumePath                    string                                                                 `name:"NFSVolume.Path"`
	DiskVolumeDiskId                 string                                                                 `name:"DiskVolume.DiskId"`
	FlexVolumeFsType                 string                                                                 `name:"FlexVolume.FsType"`
	Type                             string                                                                 `name:"Type"`
	FlexVolumeDriver                 string                                                                 `name:"FlexVolume.Driver"`
	FlexVolumeOptions                string                                                                 `name:"FlexVolume.Options"`
	NFSVolumeServer                  string                                                                 `name:"NFSVolume.Server"`
	EmptyDirVolumeMedium             string                                                                 `name:"EmptyDirVolume.Medium"`
	HostPathVolumePath               string                                                                 `name:"HostPathVolume.Path"`
	Name                             string                                                                 `name:"Name"`
	ConfigFileVolumeConfigFileToPath *[]CreateEciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath `name:"ConfigFileVolumeConfigFileToPath" type:"Repeated"`
	DiskVolumeDiskSize               string                                                                 `name:"DiskVolume.DiskSize"`
	ConfigFileVolumeDefaultMode      string                                                                 `name:"ConfigFileVolumeDefaultMode"`
	HostPathVolumeType               string                                                                 `name:"HostPathVolume.Type"`
	NFSVolumeReadOnly                string                                                                 `name:"NFSVolume.ReadOnly"`
}

// CreateEciScalingConfigurationDnsConfigOption is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationDnsConfigOption struct {
	Name  string `name:"Name"`
	Value string `name:"Value"`
}

// CreateEciScalingConfigurationSecurityContextSysctl is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationSecurityContextSysctl struct {
	Name  string `name:"Name"`
	Value string `name:"Value"`
}

// CreateEciScalingConfigurationInitContainer is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationInitContainer struct {
	Image                                 string                                                                   `name:"Image"`
	InitContainerEnvironmentVar           *[]CreateEciScalingConfigurationInitContainerInitContainerEnvironmentVar `name:"InitContainerEnvironmentVar" type:"Repeated"`
	SecurityContextCapabilityAdd          *[]string                                                                `name:"SecurityContext.Capability.Add" type:"Repeated"`
	Memory                                string                                                                   `name:"Memory"`
	WorkingDir                            string                                                                   `name:"WorkingDir"`
	Cpu                                   string                                                                   `name:"Cpu"`
	Gpu                                   string                                                                   `name:"Gpu"`
	ImagePullPolicy                       string                                                                   `name:"ImagePullPolicy"`
	Command                               *[]string                                                                `name:"Command" type:"Repeated"`
	SecurityContextRunAsUser              string                                                                   `name:"SecurityContext.RunAsUser"`
	InitContainerPort                     *[]CreateEciScalingConfigurationInitContainerInitContainerPort           `name:"InitContainerPort" type:"Repeated"`
	Arg                                   *[]string                                                                `name:"Arg" type:"Repeated"`
	Name                                  string                                                                   `name:"Name"`
	InitContainerVolumeMount              *[]CreateEciScalingConfigurationInitContainerInitContainerVolumeMount    `name:"InitContainerVolumeMount" type:"Repeated"`
	SecurityContextReadOnlyRootFilesystem string                                                                   `name:"SecurityContext.ReadOnlyRootFilesystem"`
}

// CreateEciScalingConfigurationImageRegistryCredential is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationImageRegistryCredential struct {
	Server   string `name:"Server"`
	Password string `name:"Password"`
	UserName string `name:"UserName"`
}

// CreateEciScalingConfigurationAcrRegistryInfo is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationAcrRegistryInfo struct {
	InstanceName string    `name:"InstanceName"`
	InstanceId   string    `name:"InstanceId"`
	RegionId     string    `name:"RegionId"`
	Domain       *[]string `name:"Domain" type:"Repeated"`
}

// CreateEciScalingConfigurationContainerVolumeMount is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationContainerVolumeMount struct {
	MountPath        string `name:"MountPath"`
	ReadOnly         string `name:"ReadOnly"`
	MountPropagation string `name:"MountPropagation"`
	Name             string `name:"Name"`
	SubPath          string `name:"SubPath"`
}

// CreateEciScalingConfigurationContainerPort is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationContainerPort struct {
	Protocol string `name:"Protocol"`
	Port     string `name:"Port"`
}

// CreateEciScalingConfigurationContainerEnvironmentVar is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationContainerEnvironmentVar struct {
	FieldRefFieldPath string `name:"FieldRefFieldPath"`
	Value             string `name:"Value"`
	Key               string `name:"Key"`
}

// CreateEciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath struct {
	Mode    string `name:"Mode"`
	Path    string `name:"Path"`
	Content string `name:"Content"`
}

// CreateEciScalingConfigurationInitContainerInitContainerEnvironmentVar is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationInitContainerInitContainerEnvironmentVar struct {
	FieldRefFieldPath string `name:"FieldRefFieldPath"`
	Value             string `name:"Value"`
	Key               string `name:"Key"`
}

// CreateEciScalingConfigurationInitContainerInitContainerPort is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationInitContainerInitContainerPort struct {
	Protocol string `name:"Protocol"`
	Port     string `name:"Port"`
}

// CreateEciScalingConfigurationInitContainerInitContainerVolumeMount is a repeated param struct in CreateEciScalingConfigurationRequest
type CreateEciScalingConfigurationInitContainerInitContainerVolumeMount struct {
	MountPath        string `name:"MountPath"`
	ReadOnly         string `name:"ReadOnly"`
	MountPropagation string `name:"MountPropagation"`
	Name             string `name:"Name"`
	SubPath          string `name:"SubPath"`
}

// CreateEciScalingConfigurationResponse is the response struct for api CreateEciScalingConfiguration
type CreateEciScalingConfigurationResponse struct {
	*responses.BaseResponse
	ScalingConfigurationId string `json:"ScalingConfigurationId" xml:"ScalingConfigurationId"`
	RequestId              string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateEciScalingConfigurationRequest creates a request to invoke CreateEciScalingConfiguration API
func CreateCreateEciScalingConfigurationRequest() (request *CreateEciScalingConfigurationRequest) {
	request = &CreateEciScalingConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "CreateEciScalingConfiguration", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEciScalingConfigurationResponse creates a response to parse from CreateEciScalingConfiguration response
func CreateCreateEciScalingConfigurationResponse() (response *CreateEciScalingConfigurationResponse) {
	response = &CreateEciScalingConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
