package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseAICInstance invokes the ens.ReleaseAICInstance API synchronously
func (client *Client) ReleaseAICInstance(request *ReleaseAICInstanceRequest) (response *ReleaseAICInstanceResponse, err error) {
	response = CreateReleaseAICInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseAICInstanceWithChan invokes the ens.ReleaseAICInstance API asynchronously
func (client *Client) ReleaseAICInstanceWithChan(request *ReleaseAICInstanceRequest) (<-chan *ReleaseAICInstanceResponse, <-chan error) {
	responseChan := make(chan *ReleaseAICInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseAICInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseAICInstanceWithCallback invokes the ens.ReleaseAICInstance API asynchronously
func (client *Client) ReleaseAICInstanceWithCallback(request *ReleaseAICInstanceRequest, callback func(response *ReleaseAICInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseAICInstanceResponse
		var err error
		defer close(result)
		response, err = client.ReleaseAICInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseAICInstanceRequest is the request struct for api ReleaseAICInstance
type ReleaseAICInstanceRequest struct {
	*requests.RpcRequest
	ServerId string `position:"Query" name:"ServerId"`
}

// ReleaseAICInstanceResponse is the response struct for api ReleaseAICInstance
type ReleaseAICInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleaseAICInstanceRequest creates a request to invoke ReleaseAICInstance API
func CreateReleaseAICInstanceRequest() (request *ReleaseAICInstanceRequest) {
	request = &ReleaseAICInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ReleaseAICInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseAICInstanceResponse creates a response to parse from ReleaseAICInstance response
func CreateReleaseAICInstanceResponse() (response *ReleaseAICInstanceResponse) {
	response = &ReleaseAICInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
