package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServerLoadBalancerMonitor invokes the ens.DescribeServerLoadBalancerMonitor API synchronously
func (client *Client) DescribeServerLoadBalancerMonitor(request *DescribeServerLoadBalancerMonitorRequest) (response *DescribeServerLoadBalancerMonitorResponse, err error) {
	response = CreateDescribeServerLoadBalancerMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServerLoadBalancerMonitorWithChan invokes the ens.DescribeServerLoadBalancerMonitor API asynchronously
func (client *Client) DescribeServerLoadBalancerMonitorWithChan(request *DescribeServerLoadBalancerMonitorRequest) (<-chan *DescribeServerLoadBalancerMonitorResponse, <-chan error) {
	responseChan := make(chan *DescribeServerLoadBalancerMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServerLoadBalancerMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServerLoadBalancerMonitorWithCallback invokes the ens.DescribeServerLoadBalancerMonitor API asynchronously
func (client *Client) DescribeServerLoadBalancerMonitorWithCallback(request *DescribeServerLoadBalancerMonitorRequest, callback func(response *DescribeServerLoadBalancerMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServerLoadBalancerMonitorResponse
		var err error
		defer close(result)
		response, err = client.DescribeServerLoadBalancerMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServerLoadBalancerMonitorRequest is the request struct for api DescribeServerLoadBalancerMonitor
type DescribeServerLoadBalancerMonitorRequest struct {
	*requests.RpcRequest
	StartTime      string `position:"Query" name:"StartTime"`
	EndTime        string `position:"Query" name:"EndTime"`
	LoadBalancerId string `position:"Query" name:"LoadBalancerId"`
}

// DescribeServerLoadBalancerMonitorResponse is the response struct for api DescribeServerLoadBalancerMonitor
type DescribeServerLoadBalancerMonitorResponse struct {
	*responses.BaseResponse
	RequestId                     string            `json:"RequestId" xml:"RequestId"`
	ServerLoadBalancerMonitorData []EslbMonitorList `json:"ServerLoadBalancerMonitorData" xml:"ServerLoadBalancerMonitorData"`
}

// CreateDescribeServerLoadBalancerMonitorRequest creates a request to invoke DescribeServerLoadBalancerMonitor API
func CreateDescribeServerLoadBalancerMonitorRequest() (request *DescribeServerLoadBalancerMonitorRequest) {
	request = &DescribeServerLoadBalancerMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeServerLoadBalancerMonitor", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeServerLoadBalancerMonitorResponse creates a response to parse from DescribeServerLoadBalancerMonitor response
func CreateDescribeServerLoadBalancerMonitorResponse() (response *DescribeServerLoadBalancerMonitorResponse) {
	response = &DescribeServerLoadBalancerMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
