package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSnatIpForSnatEntry invokes the ens.DeleteSnatIpForSnatEntry API synchronously
func (client *Client) DeleteSnatIpForSnatEntry(request *DeleteSnatIpForSnatEntryRequest) (response *DeleteSnatIpForSnatEntryResponse, err error) {
	response = CreateDeleteSnatIpForSnatEntryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSnatIpForSnatEntryWithChan invokes the ens.DeleteSnatIpForSnatEntry API asynchronously
func (client *Client) DeleteSnatIpForSnatEntryWithChan(request *DeleteSnatIpForSnatEntryRequest) (<-chan *DeleteSnatIpForSnatEntryResponse, <-chan error) {
	responseChan := make(chan *DeleteSnatIpForSnatEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSnatIpForSnatEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSnatIpForSnatEntryWithCallback invokes the ens.DeleteSnatIpForSnatEntry API asynchronously
func (client *Client) DeleteSnatIpForSnatEntryWithCallback(request *DeleteSnatIpForSnatEntryRequest, callback func(response *DeleteSnatIpForSnatEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSnatIpForSnatEntryResponse
		var err error
		defer close(result)
		response, err = client.DeleteSnatIpForSnatEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSnatIpForSnatEntryRequest is the request struct for api DeleteSnatIpForSnatEntry
type DeleteSnatIpForSnatEntryRequest struct {
	*requests.RpcRequest
	SnatIp      string `position:"Query" name:"SnatIp"`
	SnatEntryId string `position:"Query" name:"SnatEntryId"`
}

// DeleteSnatIpForSnatEntryResponse is the response struct for api DeleteSnatIpForSnatEntry
type DeleteSnatIpForSnatEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSnatIpForSnatEntryRequest creates a request to invoke DeleteSnatIpForSnatEntry API
func CreateDeleteSnatIpForSnatEntryRequest() (request *DeleteSnatIpForSnatEntryRequest) {
	request = &DeleteSnatIpForSnatEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteSnatIpForSnatEntry", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSnatIpForSnatEntryResponse creates a response to parse from DeleteSnatIpForSnatEntry response
func CreateDeleteSnatIpForSnatEntryResponse() (response *DeleteSnatIpForSnatEntryResponse) {
	response = &DeleteSnatIpForSnatEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
