package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteObject invokes the ens.DeleteObject API synchronously
func (client *Client) DeleteObject(request *DeleteObjectRequest) (response *DeleteObjectResponse, err error) {
	response = CreateDeleteObjectResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteObjectWithChan invokes the ens.DeleteObject API asynchronously
func (client *Client) DeleteObjectWithChan(request *DeleteObjectRequest) (<-chan *DeleteObjectResponse, <-chan error) {
	responseChan := make(chan *DeleteObjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteObject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteObjectWithCallback invokes the ens.DeleteObject API asynchronously
func (client *Client) DeleteObjectWithCallback(request *DeleteObjectRequest, callback func(response *DeleteObjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteObjectResponse
		var err error
		defer close(result)
		response, err = client.DeleteObject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteObjectRequest is the request struct for api DeleteObject
type DeleteObjectRequest struct {
	*requests.RpcRequest
	BucketName string `position:"Query" name:"BucketName"`
	ObjectKey  string `position:"Query" name:"ObjectKey"`
}

// DeleteObjectResponse is the response struct for api DeleteObject
type DeleteObjectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteObjectRequest creates a request to invoke DeleteObject API
func CreateDeleteObjectRequest() (request *DeleteObjectRequest) {
	request = &DeleteObjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteObject", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteObjectResponse creates a response to parse from DeleteObject response
func CreateDeleteObjectResponse() (response *DeleteObjectResponse) {
	response = &DeleteObjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
