package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEnsSaleConditionControl invokes the ens.DeleteEnsSaleConditionControl API synchronously
func (client *Client) DeleteEnsSaleConditionControl(request *DeleteEnsSaleConditionControlRequest) (response *DeleteEnsSaleConditionControlResponse, err error) {
	response = CreateDeleteEnsSaleConditionControlResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEnsSaleConditionControlWithChan invokes the ens.DeleteEnsSaleConditionControl API asynchronously
func (client *Client) DeleteEnsSaleConditionControlWithChan(request *DeleteEnsSaleConditionControlRequest) (<-chan *DeleteEnsSaleConditionControlResponse, <-chan error) {
	responseChan := make(chan *DeleteEnsSaleConditionControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEnsSaleConditionControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEnsSaleConditionControlWithCallback invokes the ens.DeleteEnsSaleConditionControl API asynchronously
func (client *Client) DeleteEnsSaleConditionControlWithCallback(request *DeleteEnsSaleConditionControlRequest, callback func(response *DeleteEnsSaleConditionControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEnsSaleConditionControlResponse
		var err error
		defer close(result)
		response, err = client.DeleteEnsSaleConditionControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEnsSaleConditionControlRequest is the request struct for api DeleteEnsSaleConditionControl
type DeleteEnsSaleConditionControlRequest struct {
	*requests.RpcRequest
	SaleControls  *[]DeleteEnsSaleConditionControlSaleControls `position:"Query" name:"SaleControls"  type:"Json"`
	CustomAccount string                                       `position:"Query" name:"CustomAccount"`
	CommodityCode string                                       `position:"Query" name:"CommodityCode"`
	AliUidAccount string                                       `position:"Query" name:"AliUidAccount"`
}

// DeleteEnsSaleConditionControlSaleControls is a repeated param struct in DeleteEnsSaleConditionControlRequest
type DeleteEnsSaleConditionControlSaleControls struct {
	ModuleCode        string                                                            `name:"ModuleCode"`
	ConditionControls *[]DeleteEnsSaleConditionControlSaleControlsConditionControlsItem `name:"ConditionControls" type:"Repeated"`
	OrderType         string                                                            `name:"OrderType"`
}

// DeleteEnsSaleConditionControlSaleControlsConditionControlsItem is a repeated param struct in DeleteEnsSaleConditionControlRequest
type DeleteEnsSaleConditionControlSaleControlsConditionControlsItem struct {
	ConditionControlModuleValue string `name:"ConditionControlModuleValue"`
	ConditionControlModuleCode  string `name:"ConditionControlModuleCode"`
}

// DeleteEnsSaleConditionControlResponse is the response struct for api DeleteEnsSaleConditionControl
type DeleteEnsSaleConditionControlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEnsSaleConditionControlRequest creates a request to invoke DeleteEnsSaleConditionControl API
func CreateDeleteEnsSaleConditionControlRequest() (request *DeleteEnsSaleConditionControlRequest) {
	request = &DeleteEnsSaleConditionControlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteEnsSaleConditionControl", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEnsSaleConditionControlResponse creates a response to parse from DeleteEnsSaleConditionControl response
func CreateDeleteEnsSaleConditionControlResponse() (response *DeleteEnsSaleConditionControlResponse) {
	response = &DeleteEnsSaleConditionControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
