package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDeployMachine invokes the elasticsearch.ModifyDeployMachine API synchronously
func (client *Client) ModifyDeployMachine(request *ModifyDeployMachineRequest) (response *ModifyDeployMachineResponse, err error) {
	response = CreateModifyDeployMachineResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDeployMachineWithChan invokes the elasticsearch.ModifyDeployMachine API asynchronously
func (client *Client) ModifyDeployMachineWithChan(request *ModifyDeployMachineRequest) (<-chan *ModifyDeployMachineResponse, <-chan error) {
	responseChan := make(chan *ModifyDeployMachineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDeployMachine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDeployMachineWithCallback invokes the elasticsearch.ModifyDeployMachine API asynchronously
func (client *Client) ModifyDeployMachineWithCallback(request *ModifyDeployMachineRequest, callback func(response *ModifyDeployMachineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDeployMachineResponse
		var err error
		defer close(result)
		response, err = client.ModifyDeployMachine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDeployMachineRequest is the request struct for api ModifyDeployMachine
type ModifyDeployMachineRequest struct {
	*requests.RoaRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	Body        string `position:"Body" name:"body"`
	ResId       string `position:"Path" name:"ResId"`
}

// ModifyDeployMachineResponse is the response struct for api ModifyDeployMachine
type ModifyDeployMachineResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDeployMachineRequest creates a request to invoke ModifyDeployMachine API
func CreateModifyDeployMachineRequest() (request *ModifyDeployMachineRequest) {
	request = &ModifyDeployMachineRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ModifyDeployMachine", "/openapi/collectors/[ResId]/actions/modify-deploy-machines", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDeployMachineResponse creates a response to parse from ModifyDeployMachine response
func CreateModifyDeployMachineResponse() (response *ModifyDeployMachineResponse) {
	response = &ModifyDeployMachineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
