package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeprecatedTemplates invokes the elasticsearch.ListDeprecatedTemplates API synchronously
func (client *Client) ListDeprecatedTemplates(request *ListDeprecatedTemplatesRequest) (response *ListDeprecatedTemplatesResponse, err error) {
	response = CreateListDeprecatedTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeprecatedTemplatesWithChan invokes the elasticsearch.ListDeprecatedTemplates API asynchronously
func (client *Client) ListDeprecatedTemplatesWithChan(request *ListDeprecatedTemplatesRequest) (<-chan *ListDeprecatedTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListDeprecatedTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeprecatedTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeprecatedTemplatesWithCallback invokes the elasticsearch.ListDeprecatedTemplates API asynchronously
func (client *Client) ListDeprecatedTemplatesWithCallback(request *ListDeprecatedTemplatesRequest, callback func(response *ListDeprecatedTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeprecatedTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListDeprecatedTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeprecatedTemplatesRequest is the request struct for api ListDeprecatedTemplates
type ListDeprecatedTemplatesRequest struct {
	*requests.RoaRequest
	InstanceId string           `position:"Path" name:"InstanceId"`
	Size       requests.Integer `position:"Query" name:"size"`
	Name       string           `position:"Query" name:"name"`
	Page       requests.Integer `position:"Query" name:"page"`
}

// ListDeprecatedTemplatesResponse is the response struct for api ListDeprecatedTemplates
type ListDeprecatedTemplatesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Headers   Headers      `json:"Headers" xml:"Headers"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListDeprecatedTemplatesRequest creates a request to invoke ListDeprecatedTemplates API
func CreateListDeprecatedTemplatesRequest() (request *ListDeprecatedTemplatesRequest) {
	request = &ListDeprecatedTemplatesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListDeprecatedTemplates", "/openapi/instances/[InstanceId]/deprecated-templates", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDeprecatedTemplatesResponse creates a response to parse from ListDeprecatedTemplates response
func CreateListDeprecatedTemplatesResponse() (response *ListDeprecatedTemplatesResponse) {
	response = &ListDeprecatedTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
