package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAvailableEsInstanceIds invokes the elasticsearch.ListAvailableEsInstanceIds API synchronously
func (client *Client) ListAvailableEsInstanceIds(request *ListAvailableEsInstanceIdsRequest) (response *ListAvailableEsInstanceIdsResponse, err error) {
	response = CreateListAvailableEsInstanceIdsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAvailableEsInstanceIdsWithChan invokes the elasticsearch.ListAvailableEsInstanceIds API asynchronously
func (client *Client) ListAvailableEsInstanceIdsWithChan(request *ListAvailableEsInstanceIdsRequest) (<-chan *ListAvailableEsInstanceIdsResponse, <-chan error) {
	responseChan := make(chan *ListAvailableEsInstanceIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAvailableEsInstanceIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAvailableEsInstanceIdsWithCallback invokes the elasticsearch.ListAvailableEsInstanceIds API asynchronously
func (client *Client) ListAvailableEsInstanceIdsWithCallback(request *ListAvailableEsInstanceIdsRequest, callback func(response *ListAvailableEsInstanceIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAvailableEsInstanceIdsResponse
		var err error
		defer close(result)
		response, err = client.ListAvailableEsInstanceIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAvailableEsInstanceIdsRequest is the request struct for api ListAvailableEsInstanceIds
type ListAvailableEsInstanceIdsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListAvailableEsInstanceIdsResponse is the response struct for api ListAvailableEsInstanceIds
type ListAvailableEsInstanceIdsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListAvailableEsInstanceIdsRequest creates a request to invoke ListAvailableEsInstanceIds API
func CreateListAvailableEsInstanceIdsRequest() (request *ListAvailableEsInstanceIdsRequest) {
	request = &ListAvailableEsInstanceIdsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListAvailableEsInstanceIds", "/openapi/logstashes/[InstanceId]/available-elasticsearch-for-centralized-management", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListAvailableEsInstanceIdsResponse creates a response to parse from ListAvailableEsInstanceIds response
func CreateListAvailableEsInstanceIdsResponse() (response *ListAvailableEsInstanceIdsResponse) {
	response = &ListAvailableEsInstanceIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
