package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVpd invokes the eflo.GetVpd API synchronously
func (client *Client) GetVpd(request *GetVpdRequest) (response *GetVpdResponse, err error) {
	response = CreateGetVpdResponse()
	err = client.DoAction(request, response)
	return
}

// GetVpdWithChan invokes the eflo.GetVpd API asynchronously
func (client *Client) GetVpdWithChan(request *GetVpdRequest) (<-chan *GetVpdResponse, <-chan error) {
	responseChan := make(chan *GetVpdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVpd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVpdWithCallback invokes the eflo.GetVpd API asynchronously
func (client *Client) GetVpdWithCallback(request *GetVpdRequest, callback func(response *GetVpdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVpdResponse
		var err error
		defer close(result)
		response, err = client.GetVpd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVpdRequest is the request struct for api GetVpd
type GetVpdRequest struct {
	*requests.RpcRequest
	VpdId string `position:"Body" name:"VpdId"`
}

// GetVpdResponse is the response struct for api GetVpd
type GetVpdResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateGetVpdRequest creates a request to invoke GetVpd API
func CreateGetVpdRequest() (request *GetVpdRequest) {
	request = &GetVpdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "GetVpd", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVpdResponse creates a response to parse from GetVpd response
func CreateGetVpdResponse() (response *GetVpdResponse) {
	response = &GetVpdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
