package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpd invokes the eflo.DeleteVpd API synchronously
func (client *Client) DeleteVpd(request *DeleteVpdRequest) (response *DeleteVpdResponse, err error) {
	response = CreateDeleteVpdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpdWithChan invokes the eflo.DeleteVpd API asynchronously
func (client *Client) DeleteVpdWithChan(request *DeleteVpdRequest) (<-chan *DeleteVpdResponse, <-chan error) {
	responseChan := make(chan *DeleteVpdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpdWithCallback invokes the eflo.DeleteVpd API asynchronously
func (client *Client) DeleteVpdWithCallback(request *DeleteVpdRequest, callback func(response *DeleteVpdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpdResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpdRequest is the request struct for api DeleteVpd
type DeleteVpdRequest struct {
	*requests.RpcRequest
	VpdId string `position:"Body" name:"VpdId"`
}

// DeleteVpdResponse is the response struct for api DeleteVpd
type DeleteVpdResponse struct {
	*responses.BaseResponse
}

// CreateDeleteVpdRequest creates a request to invoke DeleteVpd API
func CreateDeleteVpdRequest() (request *DeleteVpdRequest) {
	request = &DeleteVpdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DeleteVpd", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpdResponse creates a response to parse from DeleteVpd response
func CreateDeleteVpdResponse() (response *DeleteVpdResponse) {
	response = &DeleteVpdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
