package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteErRouteMap invokes the eflo.DeleteErRouteMap API synchronously
func (client *Client) DeleteErRouteMap(request *DeleteErRouteMapRequest) (response *DeleteErRouteMapResponse, err error) {
	response = CreateDeleteErRouteMapResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteErRouteMapWithChan invokes the eflo.DeleteErRouteMap API asynchronously
func (client *Client) DeleteErRouteMapWithChan(request *DeleteErRouteMapRequest) (<-chan *DeleteErRouteMapResponse, <-chan error) {
	responseChan := make(chan *DeleteErRouteMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteErRouteMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteErRouteMapWithCallback invokes the eflo.DeleteErRouteMap API asynchronously
func (client *Client) DeleteErRouteMapWithCallback(request *DeleteErRouteMapRequest, callback func(response *DeleteErRouteMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteErRouteMapResponse
		var err error
		defer close(result)
		response, err = client.DeleteErRouteMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteErRouteMapRequest is the request struct for api DeleteErRouteMap
type DeleteErRouteMapRequest struct {
	*requests.RpcRequest
	ErId          string    `position:"Body" name:"ErId"`
	ErRouteMapIds *[]string `position:"Body" name:"ErRouteMapIds"  type:"Repeated"`
}

// DeleteErRouteMapResponse is the response struct for api DeleteErRouteMap
type DeleteErRouteMapResponse struct {
	*responses.BaseResponse
}

// CreateDeleteErRouteMapRequest creates a request to invoke DeleteErRouteMap API
func CreateDeleteErRouteMapRequest() (request *DeleteErRouteMapRequest) {
	request = &DeleteErRouteMapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DeleteErRouteMap", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteErRouteMapResponse creates a response to parse from DeleteErRouteMap response
func CreateDeleteErRouteMapResponse() (response *DeleteErRouteMapResponse) {
	response = &DeleteErRouteMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
