package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConvertK8sResource invokes the edas.ConvertK8sResource API synchronously
func (client *Client) ConvertK8sResource(request *ConvertK8sResourceRequest) (response *ConvertK8sResourceResponse, err error) {
	response = CreateConvertK8sResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ConvertK8sResourceWithChan invokes the edas.ConvertK8sResource API asynchronously
func (client *Client) ConvertK8sResourceWithChan(request *ConvertK8sResourceRequest) (<-chan *ConvertK8sResourceResponse, <-chan error) {
	responseChan := make(chan *ConvertK8sResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConvertK8sResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConvertK8sResourceWithCallback invokes the edas.ConvertK8sResource API asynchronously
func (client *Client) ConvertK8sResourceWithCallback(request *ConvertK8sResourceRequest, callback func(response *ConvertK8sResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConvertK8sResourceResponse
		var err error
		defer close(result)
		response, err = client.ConvertK8sResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConvertK8sResourceRequest is the request struct for api ConvertK8sResource
type ConvertK8sResourceRequest struct {
	*requests.RoaRequest
	Namespace    string `position:"Query" name:"Namespace"`
	ResourceName string `position:"Query" name:"ResourceName"`
	ClusterId    string `position:"Query" name:"ClusterId"`
	ResourceType string `position:"Query" name:"ResourceType"`
}

// ConvertK8sResourceResponse is the response struct for api ConvertK8sResource
type ConvertK8sResourceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConvertK8sResourceRequest creates a request to invoke ConvertK8sResource API
func CreateConvertK8sResourceRequest() (request *ConvertK8sResourceRequest) {
	request = &ConvertK8sResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ConvertK8sResource", "/pop/v5/oam/k8s_resource_convert", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConvertK8sResourceResponse creates a response to parse from ConvertK8sResource response
func CreateConvertK8sResourceResponse() (response *ConvertK8sResourceResponse) {
	response = &ConvertK8sResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
