package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RedeployDedicatedHost invokes the ecs.RedeployDedicatedHost API synchronously
func (client *Client) RedeployDedicatedHost(request *RedeployDedicatedHostRequest) (response *RedeployDedicatedHostResponse, err error) {
	response = CreateRedeployDedicatedHostResponse()
	err = client.DoAction(request, response)
	return
}

// RedeployDedicatedHostWithChan invokes the ecs.RedeployDedicatedHost API asynchronously
func (client *Client) RedeployDedicatedHostWithChan(request *RedeployDedicatedHostRequest) (<-chan *RedeployDedicatedHostResponse, <-chan error) {
	responseChan := make(chan *RedeployDedicatedHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RedeployDedicatedHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RedeployDedicatedHostWithCallback invokes the ecs.RedeployDedicatedHost API asynchronously
func (client *Client) RedeployDedicatedHostWithCallback(request *RedeployDedicatedHostRequest, callback func(response *RedeployDedicatedHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RedeployDedicatedHostResponse
		var err error
		defer close(result)
		response, err = client.RedeployDedicatedHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RedeployDedicatedHostRequest is the request struct for api RedeployDedicatedHost
type RedeployDedicatedHostRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DedicatedHostId      string           `position:"Query" name:"DedicatedHostId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MigrationType        string           `position:"Query" name:"MigrationType"`
}

// RedeployDedicatedHostResponse is the response struct for api RedeployDedicatedHost
type RedeployDedicatedHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRedeployDedicatedHostRequest creates a request to invoke RedeployDedicatedHost API
func CreateRedeployDedicatedHostRequest() (request *RedeployDedicatedHostRequest) {
	request = &RedeployDedicatedHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "RedeployDedicatedHost", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRedeployDedicatedHostResponse creates a response to parse from RedeployDedicatedHost response
func CreateRedeployDedicatedHostResponse() (response *RedeployDedicatedHostResponse) {
	response = &RedeployDedicatedHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
