package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTerminalSessions invokes the ecs.DescribeTerminalSessions API synchronously
func (client *Client) DescribeTerminalSessions(request *DescribeTerminalSessionsRequest) (response *DescribeTerminalSessionsResponse, err error) {
	response = CreateDescribeTerminalSessionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTerminalSessionsWithChan invokes the ecs.DescribeTerminalSessions API asynchronously
func (client *Client) DescribeTerminalSessionsWithChan(request *DescribeTerminalSessionsRequest) (<-chan *DescribeTerminalSessionsResponse, <-chan error) {
	responseChan := make(chan *DescribeTerminalSessionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTerminalSessions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTerminalSessionsWithCallback invokes the ecs.DescribeTerminalSessions API asynchronously
func (client *Client) DescribeTerminalSessionsWithCallback(request *DescribeTerminalSessionsRequest, callback func(response *DescribeTerminalSessionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTerminalSessionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeTerminalSessions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTerminalSessionsRequest is the request struct for api DescribeTerminalSessions
type DescribeTerminalSessionsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SessionId            string           `position:"Query" name:"SessionId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeTerminalSessionsResponse is the response struct for api DescribeTerminalSessions
type DescribeTerminalSessionsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	NextToken string   `json:"NextToken" xml:"NextToken"`
	Sessions  Sessions `json:"Sessions" xml:"Sessions"`
}

// CreateDescribeTerminalSessionsRequest creates a request to invoke DescribeTerminalSessions API
func CreateDescribeTerminalSessionsRequest() (request *DescribeTerminalSessionsRequest) {
	request = &DescribeTerminalSessionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeTerminalSessions", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTerminalSessionsResponse creates a response to parse from DescribeTerminalSessions response
func CreateDescribeTerminalSessionsResponse() (response *DescribeTerminalSessionsResponse) {
	response = &DescribeTerminalSessionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
