package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskDefaultKMSKeyId invokes the ecs.DescribeDiskDefaultKMSKeyId API synchronously
func (client *Client) DescribeDiskDefaultKMSKeyId(request *DescribeDiskDefaultKMSKeyIdRequest) (response *DescribeDiskDefaultKMSKeyIdResponse, err error) {
	response = CreateDescribeDiskDefaultKMSKeyIdResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskDefaultKMSKeyIdWithChan invokes the ecs.DescribeDiskDefaultKMSKeyId API asynchronously
func (client *Client) DescribeDiskDefaultKMSKeyIdWithChan(request *DescribeDiskDefaultKMSKeyIdRequest) (<-chan *DescribeDiskDefaultKMSKeyIdResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskDefaultKMSKeyIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskDefaultKMSKeyId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskDefaultKMSKeyIdWithCallback invokes the ecs.DescribeDiskDefaultKMSKeyId API asynchronously
func (client *Client) DescribeDiskDefaultKMSKeyIdWithCallback(request *DescribeDiskDefaultKMSKeyIdRequest, callback func(response *DescribeDiskDefaultKMSKeyIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskDefaultKMSKeyIdResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskDefaultKMSKeyId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskDefaultKMSKeyIdRequest is the request struct for api DescribeDiskDefaultKMSKeyId
type DescribeDiskDefaultKMSKeyIdRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// DescribeDiskDefaultKMSKeyIdResponse is the response struct for api DescribeDiskDefaultKMSKeyId
type DescribeDiskDefaultKMSKeyIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	KMSKeyId  string `json:"KMSKeyId" xml:"KMSKeyId"`
}

// CreateDescribeDiskDefaultKMSKeyIdRequest creates a request to invoke DescribeDiskDefaultKMSKeyId API
func CreateDescribeDiskDefaultKMSKeyIdRequest() (request *DescribeDiskDefaultKMSKeyIdRequest) {
	request = &DescribeDiskDefaultKMSKeyIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeDiskDefaultKMSKeyId", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiskDefaultKMSKeyIdResponse creates a response to parse from DescribeDiskDefaultKMSKeyId response
func CreateDescribeDiskDefaultKMSKeyIdResponse() (response *DescribeDiskDefaultKMSKeyIdResponse) {
	response = &DescribeDiskDefaultKMSKeyIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
