package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRefundPrice invokes the ecd.DescribeRefundPrice API synchronously
func (client *Client) DescribeRefundPrice(request *DescribeRefundPriceRequest) (response *DescribeRefundPriceResponse, err error) {
	response = CreateDescribeRefundPriceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRefundPriceWithChan invokes the ecd.DescribeRefundPrice API asynchronously
func (client *Client) DescribeRefundPriceWithChan(request *DescribeRefundPriceRequest) (<-chan *DescribeRefundPriceResponse, <-chan error) {
	responseChan := make(chan *DescribeRefundPriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRefundPrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRefundPriceWithCallback invokes the ecd.DescribeRefundPrice API asynchronously
func (client *Client) DescribeRefundPriceWithCallback(request *DescribeRefundPriceRequest, callback func(response *DescribeRefundPriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRefundPriceResponse
		var err error
		defer close(result)
		response, err = client.DescribeRefundPrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRefundPriceRequest is the request struct for api DescribeRefundPrice
type DescribeRefundPriceRequest struct {
	*requests.RpcRequest
	RefundType     string    `position:"Query" name:"RefundType"`
	RefundParamMap string    `position:"Query" name:"RefundParamMap"`
	DesktopId      *[]string `position:"Query" name:"DesktopId"  type:"Repeated"`
}

// DescribeRefundPriceResponse is the response struct for api DescribeRefundPrice
type DescribeRefundPriceResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	PriceInfo PriceInfo `json:"PriceInfo" xml:"PriceInfo"`
}

// CreateDescribeRefundPriceRequest creates a request to invoke DescribeRefundPrice API
func CreateDescribeRefundPriceRequest() (request *DescribeRefundPriceRequest) {
	request = &DescribeRefundPriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeRefundPrice", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRefundPriceResponse creates a response to parse from DescribeRefundPrice response
func CreateDescribeRefundPriceResponse() (response *DescribeRefundPriceResponse) {
	response = &DescribeRefundPriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
