package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClientEvents invokes the ecd.DescribeClientEvents API synchronously
func (client *Client) DescribeClientEvents(request *DescribeClientEventsRequest) (response *DescribeClientEventsResponse, err error) {
	response = CreateDescribeClientEventsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClientEventsWithChan invokes the ecd.DescribeClientEvents API asynchronously
func (client *Client) DescribeClientEventsWithChan(request *DescribeClientEventsRequest) (<-chan *DescribeClientEventsResponse, <-chan error) {
	responseChan := make(chan *DescribeClientEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClientEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClientEventsWithCallback invokes the ecd.DescribeClientEvents API asynchronously
func (client *Client) DescribeClientEventsWithCallback(request *DescribeClientEventsRequest, callback func(response *DescribeClientEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClientEventsResponse
		var err error
		defer close(result)
		response, err = client.DescribeClientEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClientEventsRequest is the request struct for api DescribeClientEvents
type DescribeClientEventsRequest struct {
	*requests.RpcRequest
	OfficeSiteId   string           `position:"Query" name:"OfficeSiteId"`
	EventTypes     *[]string        `position:"Query" name:"EventTypes"  type:"Repeated"`
	StartTime      string           `position:"Query" name:"StartTime"`
	NextToken      string           `position:"Query" name:"NextToken"`
	EndUserId      string           `position:"Query" name:"EndUserId"`
	DirectoryId    string           `position:"Query" name:"DirectoryId"`
	DesktopId      string           `position:"Query" name:"DesktopId"`
	DesktopName    string           `position:"Query" name:"DesktopName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OfficeSiteName string           `position:"Query" name:"OfficeSiteName"`
	DesktopIp      string           `position:"Query" name:"DesktopIp"`
	MaxResults     requests.Integer `position:"Query" name:"MaxResults"`
	EventType      string           `position:"Query" name:"EventType"`
}

// DescribeClientEventsResponse is the response struct for api DescribeClientEvents
type DescribeClientEventsResponse struct {
	*responses.BaseResponse
	NextToken string  `json:"NextToken" xml:"NextToken"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Events    []Event `json:"Events" xml:"Events"`
}

// CreateDescribeClientEventsRequest creates a request to invoke DescribeClientEvents API
func CreateDescribeClientEventsRequest() (request *DescribeClientEventsRequest) {
	request = &DescribeClientEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeClientEvents", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClientEventsResponse creates a response to parse from DescribeClientEvents response
func CreateDescribeClientEventsResponse() (response *DescribeClientEventsResponse) {
	response = &DescribeClientEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
