package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartDiskMonitor invokes the ebs.StartDiskMonitor API synchronously
func (client *Client) StartDiskMonitor(request *StartDiskMonitorRequest) (response *StartDiskMonitorResponse, err error) {
	response = CreateStartDiskMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// StartDiskMonitorWithChan invokes the ebs.StartDiskMonitor API asynchronously
func (client *Client) StartDiskMonitorWithChan(request *StartDiskMonitorRequest) (<-chan *StartDiskMonitorResponse, <-chan error) {
	responseChan := make(chan *StartDiskMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartDiskMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartDiskMonitorWithCallback invokes the ebs.StartDiskMonitor API asynchronously
func (client *Client) StartDiskMonitorWithCallback(request *StartDiskMonitorRequest, callback func(response *StartDiskMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartDiskMonitorResponse
		var err error
		defer close(result)
		response, err = client.StartDiskMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartDiskMonitorRequest is the request struct for api StartDiskMonitor
type StartDiskMonitorRequest struct {
	*requests.RpcRequest
	DiskIds *[]string `position:"Query" name:"DiskIds"  type:"Json"`
}

// StartDiskMonitorResponse is the response struct for api StartDiskMonitor
type StartDiskMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartDiskMonitorRequest creates a request to invoke StartDiskMonitor API
func CreateStartDiskMonitorRequest() (request *StartDiskMonitorRequest) {
	request = &StartDiskMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "StartDiskMonitor", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartDiskMonitorResponse creates a response to parse from StartDiskMonitor response
func CreateStartDiskMonitorResponse() (response *StartDiskMonitorResponse) {
	response = &StartDiskMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
