package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryVoipNumberBindInfos invokes the dyvmsapi.QueryVoipNumberBindInfos API synchronously
func (client *Client) QueryVoipNumberBindInfos(request *QueryVoipNumberBindInfosRequest) (response *QueryVoipNumberBindInfosResponse, err error) {
	response = CreateQueryVoipNumberBindInfosResponse()
	err = client.DoAction(request, response)
	return
}

// QueryVoipNumberBindInfosWithChan invokes the dyvmsapi.QueryVoipNumberBindInfos API asynchronously
func (client *Client) QueryVoipNumberBindInfosWithChan(request *QueryVoipNumberBindInfosRequest) (<-chan *QueryVoipNumberBindInfosResponse, <-chan error) {
	responseChan := make(chan *QueryVoipNumberBindInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryVoipNumberBindInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryVoipNumberBindInfosWithCallback invokes the dyvmsapi.QueryVoipNumberBindInfos API asynchronously
func (client *Client) QueryVoipNumberBindInfosWithCallback(request *QueryVoipNumberBindInfosRequest, callback func(response *QueryVoipNumberBindInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryVoipNumberBindInfosResponse
		var err error
		defer close(result)
		response, err = client.QueryVoipNumberBindInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryVoipNumberBindInfosRequest is the request struct for api QueryVoipNumberBindInfos
type QueryVoipNumberBindInfosRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VoipId               string           `position:"Query" name:"VoipId"`
}

// QueryVoipNumberBindInfosResponse is the response struct for api QueryVoipNumberBindInfos
type QueryVoipNumberBindInfosResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateQueryVoipNumberBindInfosRequest creates a request to invoke QueryVoipNumberBindInfos API
func CreateQueryVoipNumberBindInfosRequest() (request *QueryVoipNumberBindInfosRequest) {
	request = &QueryVoipNumberBindInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "QueryVoipNumberBindInfos", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryVoipNumberBindInfosResponse creates a response to parse from QueryVoipNumberBindInfos response
func CreateQueryVoipNumberBindInfosResponse() (response *QueryVoipNumberBindInfosResponse) {
	response = &QueryVoipNumberBindInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
