package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePhoneNumberOperatorAttribute invokes the dytnsapi.DescribePhoneNumberOperatorAttribute API synchronously
func (client *Client) DescribePhoneNumberOperatorAttribute(request *DescribePhoneNumberOperatorAttributeRequest) (response *DescribePhoneNumberOperatorAttributeResponse, err error) {
	response = CreateDescribePhoneNumberOperatorAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePhoneNumberOperatorAttributeWithChan invokes the dytnsapi.DescribePhoneNumberOperatorAttribute API asynchronously
func (client *Client) DescribePhoneNumberOperatorAttributeWithChan(request *DescribePhoneNumberOperatorAttributeRequest) (<-chan *DescribePhoneNumberOperatorAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribePhoneNumberOperatorAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePhoneNumberOperatorAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePhoneNumberOperatorAttributeWithCallback invokes the dytnsapi.DescribePhoneNumberOperatorAttribute API asynchronously
func (client *Client) DescribePhoneNumberOperatorAttributeWithCallback(request *DescribePhoneNumberOperatorAttributeRequest, callback func(response *DescribePhoneNumberOperatorAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePhoneNumberOperatorAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribePhoneNumberOperatorAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePhoneNumberOperatorAttributeRequest is the request struct for api DescribePhoneNumberOperatorAttribute
type DescribePhoneNumberOperatorAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	RouteName            string           `position:"Query" name:"RouteName"`
	Mask                 string           `position:"Query" name:"Mask"`
	ResultCount          string           `position:"Query" name:"ResultCount"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AuthCode             string           `position:"Query" name:"AuthCode"`
	InputNumber          string           `position:"Query" name:"InputNumber"`
	FlowName             string           `position:"Query" name:"FlowName"`
}

// DescribePhoneNumberOperatorAttributeResponse is the response struct for api DescribePhoneNumberOperatorAttribute
type DescribePhoneNumberOperatorAttributeResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribePhoneNumberOperatorAttributeRequest creates a request to invoke DescribePhoneNumberOperatorAttribute API
func CreateDescribePhoneNumberOperatorAttributeRequest() (request *DescribePhoneNumberOperatorAttributeRequest) {
	request = &DescribePhoneNumberOperatorAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "DescribePhoneNumberOperatorAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePhoneNumberOperatorAttributeResponse creates a response to parse from DescribePhoneNumberOperatorAttribute response
func CreateDescribePhoneNumberOperatorAttributeResponse() (response *DescribePhoneNumberOperatorAttributeResponse) {
	response = &DescribePhoneNumberOperatorAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
