package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendBatchCardSms invokes the dysmsapi.SendBatchCardSms API synchronously
func (client *Client) SendBatchCardSms(request *SendBatchCardSmsRequest) (response *SendBatchCardSmsResponse, err error) {
	response = CreateSendBatchCardSmsResponse()
	err = client.DoAction(request, response)
	return
}

// SendBatchCardSmsWithChan invokes the dysmsapi.SendBatchCardSms API asynchronously
func (client *Client) SendBatchCardSmsWithChan(request *SendBatchCardSmsRequest) (<-chan *SendBatchCardSmsResponse, <-chan error) {
	responseChan := make(chan *SendBatchCardSmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendBatchCardSms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendBatchCardSmsWithCallback invokes the dysmsapi.SendBatchCardSms API asynchronously
func (client *Client) SendBatchCardSmsWithCallback(request *SendBatchCardSmsRequest, callback func(response *SendBatchCardSmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendBatchCardSmsResponse
		var err error
		defer close(result)
		response, err = client.SendBatchCardSms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendBatchCardSmsRequest is the request struct for api SendBatchCardSms
type SendBatchCardSmsRequest struct {
	*requests.RpcRequest
	ProductCode              string           `position:"Query" name:"ProductCode"`
	ResourceOwnerId          requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TemplateParamJson        string           `position:"Query" name:"TemplateParamJson"`
	DigitalTemplateCode      string           `position:"Query" name:"DigitalTemplateCode"`
	FallbackType             string           `position:"Query" name:"FallbackType"`
	CardTemplateParamJson    string           `position:"Query" name:"CardTemplateParamJson"`
	CardTemplateCode         string           `position:"Query" name:"CardTemplateCode"`
	SmsTemplateParamJson     string           `position:"Query" name:"SmsTemplateParamJson"`
	SmsTemplateCode          string           `position:"Query" name:"SmsTemplateCode"`
	SmsUpExtendCodeJson      string           `position:"Query" name:"SmsUpExtendCodeJson"`
	OutId                    string           `position:"Query" name:"OutId"`
	DigitalTemplateParamJson string           `position:"Query" name:"DigitalTemplateParamJson"`
	SignNameJson             string           `position:"Query" name:"SignNameJson"`
	TemplateCode             string           `position:"Query" name:"TemplateCode"`
	PhoneNumberJson          string           `position:"Query" name:"PhoneNumberJson"`
}

// SendBatchCardSmsResponse is the response struct for api SendBatchCardSms
type SendBatchCardSmsResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSendBatchCardSmsRequest creates a request to invoke SendBatchCardSms API
func CreateSendBatchCardSmsRequest() (request *SendBatchCardSmsRequest) {
	request = &SendBatchCardSmsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "SendBatchCardSms", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendBatchCardSmsResponse creates a response to parse from SendBatchCardSms response
func CreateSendBatchCardSmsResponse() (response *SendBatchCardSmsResponse) {
	response = &SendBatchCardSmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
