package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckMobilesCardSupport invokes the dysmsapi.CheckMobilesCardSupport API synchronously
func (client *Client) CheckMobilesCardSupport(request *CheckMobilesCardSupportRequest) (response *CheckMobilesCardSupportResponse, err error) {
	response = CreateCheckMobilesCardSupportResponse()
	err = client.DoAction(request, response)
	return
}

// CheckMobilesCardSupportWithChan invokes the dysmsapi.CheckMobilesCardSupport API asynchronously
func (client *Client) CheckMobilesCardSupportWithChan(request *CheckMobilesCardSupportRequest) (<-chan *CheckMobilesCardSupportResponse, <-chan error) {
	responseChan := make(chan *CheckMobilesCardSupportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckMobilesCardSupport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckMobilesCardSupportWithCallback invokes the dysmsapi.CheckMobilesCardSupport API asynchronously
func (client *Client) CheckMobilesCardSupportWithCallback(request *CheckMobilesCardSupportRequest, callback func(response *CheckMobilesCardSupportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckMobilesCardSupportResponse
		var err error
		defer close(result)
		response, err = client.CheckMobilesCardSupport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckMobilesCardSupportRequest is the request struct for api CheckMobilesCardSupport
type CheckMobilesCardSupportRequest struct {
	*requests.RpcRequest
	ProductCode     string               `position:"Query" name:"ProductCode"`
	ResourceOwnerId requests.Integer     `position:"Query" name:"ResourceOwnerId"`
	Mobiles         *[]map[string]string `position:"Query" name:"Mobiles"  type:"Repeated"`
	TemplateCode    string               `position:"Query" name:"TemplateCode"`
}

// CheckMobilesCardSupportResponse is the response struct for api CheckMobilesCardSupport
type CheckMobilesCardSupportResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCheckMobilesCardSupportRequest creates a request to invoke CheckMobilesCardSupport API
func CreateCheckMobilesCardSupportRequest() (request *CheckMobilesCardSupportRequest) {
	request = &CheckMobilesCardSupportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "CheckMobilesCardSupport", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckMobilesCardSupportResponse creates a response to parse from CheckMobilesCardSupport response
func CreateCheckMobilesCardSupportResponse() (response *CheckMobilesCardSupportResponse) {
	response = &CheckMobilesCardSupportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
