package dt_oc_info

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOcNegativeFoodDrugPunishment invokes the dt_oc_info.GetOcNegativeFoodDrugPunishment API synchronously
func (client *Client) GetOcNegativeFoodDrugPunishment(request *GetOcNegativeFoodDrugPunishmentRequest) (response *GetOcNegativeFoodDrugPunishmentResponse, err error) {
	response = CreateGetOcNegativeFoodDrugPunishmentResponse()
	err = client.DoAction(request, response)
	return
}

// GetOcNegativeFoodDrugPunishmentWithChan invokes the dt_oc_info.GetOcNegativeFoodDrugPunishment API asynchronously
func (client *Client) GetOcNegativeFoodDrugPunishmentWithChan(request *GetOcNegativeFoodDrugPunishmentRequest) (<-chan *GetOcNegativeFoodDrugPunishmentResponse, <-chan error) {
	responseChan := make(chan *GetOcNegativeFoodDrugPunishmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOcNegativeFoodDrugPunishment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOcNegativeFoodDrugPunishmentWithCallback invokes the dt_oc_info.GetOcNegativeFoodDrugPunishment API asynchronously
func (client *Client) GetOcNegativeFoodDrugPunishmentWithCallback(request *GetOcNegativeFoodDrugPunishmentRequest, callback func(response *GetOcNegativeFoodDrugPunishmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOcNegativeFoodDrugPunishmentResponse
		var err error
		defer close(result)
		response, err = client.GetOcNegativeFoodDrugPunishment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOcNegativeFoodDrugPunishmentRequest is the request struct for api GetOcNegativeFoodDrugPunishment
type GetOcNegativeFoodDrugPunishmentRequest struct {
	*requests.RpcRequest
	PageNo    requests.Integer `position:"Body" name:"PageNo"`
	PageSize  requests.Integer `position:"Body" name:"PageSize"`
	SearchKey string           `position:"Body" name:"SearchKey"`
}

// GetOcNegativeFoodDrugPunishmentResponse is the response struct for api GetOcNegativeFoodDrugPunishment
type GetOcNegativeFoodDrugPunishmentResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Message   string     `json:"Message" xml:"Message"`
	TotalNum  int        `json:"TotalNum" xml:"TotalNum"`
	PageIndex int        `json:"PageIndex" xml:"PageIndex"`
	PageNum   int        `json:"PageNum" xml:"PageNum"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetOcNegativeFoodDrugPunishmentRequest creates a request to invoke GetOcNegativeFoodDrugPunishment API
func CreateGetOcNegativeFoodDrugPunishmentRequest() (request *GetOcNegativeFoodDrugPunishmentRequest) {
	request = &GetOcNegativeFoodDrugPunishmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dt-oc-info", "2022-08-29", "GetOcNegativeFoodDrugPunishment", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOcNegativeFoodDrugPunishmentResponse creates a response to parse from GetOcNegativeFoodDrugPunishment response
func CreateGetOcNegativeFoodDrugPunishmentResponse() (response *GetOcNegativeFoodDrugPunishmentResponse) {
	response = &GetOcNegativeFoodDrugPunishmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
