package documentautoml

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PredictClassifierModel invokes the documentautoml.PredictClassifierModel API synchronously
func (client *Client) PredictClassifierModel(request *PredictClassifierModelRequest) (response *PredictClassifierModelResponse, err error) {
	response = CreatePredictClassifierModelResponse()
	err = client.DoAction(request, response)
	return
}

// PredictClassifierModelWithChan invokes the documentautoml.PredictClassifierModel API asynchronously
func (client *Client) PredictClassifierModelWithChan(request *PredictClassifierModelRequest) (<-chan *PredictClassifierModelResponse, <-chan error) {
	responseChan := make(chan *PredictClassifierModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PredictClassifierModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PredictClassifierModelWithCallback invokes the documentautoml.PredictClassifierModel API asynchronously
func (client *Client) PredictClassifierModelWithCallback(request *PredictClassifierModelRequest, callback func(response *PredictClassifierModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PredictClassifierModelResponse
		var err error
		defer close(result)
		response, err = client.PredictClassifierModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PredictClassifierModelRequest is the request struct for api PredictClassifierModel
type PredictClassifierModelRequest struct {
	*requests.RpcRequest
	Body           string           `position:"Body" name:"body"`
	Content        string           `position:"Query" name:"Content"`
	ClassifierId   requests.Integer `position:"Query" name:"ClassifierId"`
	AutoPrediction requests.Boolean `position:"Query" name:"AutoPrediction"`
}

// PredictClassifierModelResponse is the response struct for api PredictClassifierModel
type PredictClassifierModelResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Code      int                    `json:"Code" xml:"Code"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
	Message   string                 `json:"Message" xml:"Message"`
}

// CreatePredictClassifierModelRequest creates a request to invoke PredictClassifierModel API
func CreatePredictClassifierModelRequest() (request *PredictClassifierModelRequest) {
	request = &PredictClassifierModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("documentAutoml", "2022-12-29", "PredictClassifierModel", "documentAutoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePredictClassifierModelResponse creates a response to parse from PredictClassifierModel response
func CreatePredictClassifierModelResponse() (response *PredictClassifierModelResponse) {
	response = &PredictClassifierModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
