package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateScenario invokes the dms_enterprise.UpdateScenario API synchronously
func (client *Client) UpdateScenario(request *UpdateScenarioRequest) (response *UpdateScenarioResponse, err error) {
	response = CreateUpdateScenarioResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateScenarioWithChan invokes the dms_enterprise.UpdateScenario API asynchronously
func (client *Client) UpdateScenarioWithChan(request *UpdateScenarioRequest) (<-chan *UpdateScenarioResponse, <-chan error) {
	responseChan := make(chan *UpdateScenarioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateScenario(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateScenarioWithCallback invokes the dms_enterprise.UpdateScenario API asynchronously
func (client *Client) UpdateScenarioWithCallback(request *UpdateScenarioRequest, callback func(response *UpdateScenarioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateScenarioResponse
		var err error
		defer close(result)
		response, err = client.UpdateScenario(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateScenarioRequest is the request struct for api UpdateScenario
type UpdateScenarioRequest struct {
	*requests.RpcRequest
	Description  string           `position:"Query" name:"Description"`
	Tid          requests.Integer `position:"Query" name:"Tid"`
	ScenarioId   string           `position:"Query" name:"ScenarioId"`
	ScenarioName string           `position:"Query" name:"ScenarioName"`
}

// UpdateScenarioResponse is the response struct for api UpdateScenario
type UpdateScenarioResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateScenarioRequest creates a request to invoke UpdateScenario API
func CreateUpdateScenarioRequest() (request *UpdateScenarioRequest) {
	request = &UpdateScenarioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateScenario", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateScenarioResponse creates a response to parse from UpdateScenario response
func CreateUpdateScenarioResponse() (response *UpdateScenarioResponse) {
	response = &UpdateScenarioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
