package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataImportSQLType invokes the dms_enterprise.ListDataImportSQLType API synchronously
func (client *Client) ListDataImportSQLType(request *ListDataImportSQLTypeRequest) (response *ListDataImportSQLTypeResponse, err error) {
	response = CreateListDataImportSQLTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataImportSQLTypeWithChan invokes the dms_enterprise.ListDataImportSQLType API asynchronously
func (client *Client) ListDataImportSQLTypeWithChan(request *ListDataImportSQLTypeRequest) (<-chan *ListDataImportSQLTypeResponse, <-chan error) {
	responseChan := make(chan *ListDataImportSQLTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataImportSQLType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataImportSQLTypeWithCallback invokes the dms_enterprise.ListDataImportSQLType API asynchronously
func (client *Client) ListDataImportSQLTypeWithCallback(request *ListDataImportSQLTypeRequest, callback func(response *ListDataImportSQLTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataImportSQLTypeResponse
		var err error
		defer close(result)
		response, err = client.ListDataImportSQLType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataImportSQLTypeRequest is the request struct for api ListDataImportSQLType
type ListDataImportSQLTypeRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// ListDataImportSQLTypeResponse is the response struct for api ListDataImportSQLType
type ListDataImportSQLTypeResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	Success       bool     `json:"Success" xml:"Success"`
	ErrorMessage  string   `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode     string   `json:"ErrorCode" xml:"ErrorCode"`
	SqlTypeResult []string `json:"SqlTypeResult" xml:"SqlTypeResult"`
}

// CreateListDataImportSQLTypeRequest creates a request to invoke ListDataImportSQLType API
func CreateListDataImportSQLTypeRequest() (request *ListDataImportSQLTypeRequest) {
	request = &ListDataImportSQLTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListDataImportSQLType", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDataImportSQLTypeResponse creates a response to parse from ListDataImportSQLType response
func CreateListDataImportSQLTypeResponse() (response *ListDataImportSQLTypeResponse) {
	response = &ListDataImportSQLTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
