package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIntervalLimitOfSLA invokes the dms_enterprise.GetIntervalLimitOfSLA API synchronously
func (client *Client) GetIntervalLimitOfSLA(request *GetIntervalLimitOfSLARequest) (response *GetIntervalLimitOfSLAResponse, err error) {
	response = CreateGetIntervalLimitOfSLAResponse()
	err = client.DoAction(request, response)
	return
}

// GetIntervalLimitOfSLAWithChan invokes the dms_enterprise.GetIntervalLimitOfSLA API asynchronously
func (client *Client) GetIntervalLimitOfSLAWithChan(request *GetIntervalLimitOfSLARequest) (<-chan *GetIntervalLimitOfSLAResponse, <-chan error) {
	responseChan := make(chan *GetIntervalLimitOfSLAResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIntervalLimitOfSLA(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIntervalLimitOfSLAWithCallback invokes the dms_enterprise.GetIntervalLimitOfSLA API asynchronously
func (client *Client) GetIntervalLimitOfSLAWithCallback(request *GetIntervalLimitOfSLARequest, callback func(response *GetIntervalLimitOfSLAResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIntervalLimitOfSLAResponse
		var err error
		defer close(result)
		response, err = client.GetIntervalLimitOfSLA(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIntervalLimitOfSLARequest is the request struct for api GetIntervalLimitOfSLA
type GetIntervalLimitOfSLARequest struct {
	*requests.RpcRequest
	DagId requests.Integer `position:"Query" name:"DagId"`
	Tid   requests.Integer `position:"Query" name:"Tid"`
}

// GetIntervalLimitOfSLAResponse is the response struct for api GetIntervalLimitOfSLA
type GetIntervalLimitOfSLAResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ErrorCode     string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage  string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success       bool   `json:"Success" xml:"Success"`
	IntervalLimit int    `json:"IntervalLimit" xml:"IntervalLimit"`
}

// CreateGetIntervalLimitOfSLARequest creates a request to invoke GetIntervalLimitOfSLA API
func CreateGetIntervalLimitOfSLARequest() (request *GetIntervalLimitOfSLARequest) {
	request = &GetIntervalLimitOfSLARequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetIntervalLimitOfSLA", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetIntervalLimitOfSLAResponse creates a response to parse from GetIntervalLimitOfSLA response
func CreateGetIntervalLimitOfSLAResponse() (response *GetIntervalLimitOfSLAResponse) {
	response = &GetIntervalLimitOfSLAResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
