package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataLakeCatalog invokes the dms_enterprise.GetDataLakeCatalog API synchronously
func (client *Client) GetDataLakeCatalog(request *GetDataLakeCatalogRequest) (response *GetDataLakeCatalogResponse, err error) {
	response = CreateGetDataLakeCatalogResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataLakeCatalogWithChan invokes the dms_enterprise.GetDataLakeCatalog API asynchronously
func (client *Client) GetDataLakeCatalogWithChan(request *GetDataLakeCatalogRequest) (<-chan *GetDataLakeCatalogResponse, <-chan error) {
	responseChan := make(chan *GetDataLakeCatalogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataLakeCatalog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataLakeCatalogWithCallback invokes the dms_enterprise.GetDataLakeCatalog API asynchronously
func (client *Client) GetDataLakeCatalogWithCallback(request *GetDataLakeCatalogRequest, callback func(response *GetDataLakeCatalogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataLakeCatalogResponse
		var err error
		defer close(result)
		response, err = client.GetDataLakeCatalog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataLakeCatalogRequest is the request struct for api GetDataLakeCatalog
type GetDataLakeCatalogRequest struct {
	*requests.RpcRequest
	Tid         requests.Integer `position:"Query" name:"Tid"`
	CatalogName string           `position:"Query" name:"CatalogName"`
	DataRegion  string           `position:"Query" name:"DataRegion"`
}

// GetDataLakeCatalogResponse is the response struct for api GetDataLakeCatalog
type GetDataLakeCatalogResponse struct {
	*responses.BaseResponse
	RequestId    string  `json:"RequestId" xml:"RequestId"`
	Success      bool    `json:"Success" xml:"Success"`
	ErrorCode    string  `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string  `json:"ErrorMessage" xml:"ErrorMessage"`
	Catalog      Catalog `json:"Catalog" xml:"Catalog"`
}

// CreateGetDataLakeCatalogRequest creates a request to invoke GetDataLakeCatalog API
func CreateGetDataLakeCatalogRequest() (request *GetDataLakeCatalogRequest) {
	request = &GetDataLakeCatalogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataLakeCatalog", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataLakeCatalogResponse creates a response to parse from GetDataLakeCatalog response
func CreateGetDataLakeCatalogResponse() (response *GetDataLakeCatalogResponse) {
	response = &GetDataLakeCatalogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
