package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataExportOrder invokes the dms_enterprise.CreateDataExportOrder API synchronously
func (client *Client) CreateDataExportOrder(request *CreateDataExportOrderRequest) (response *CreateDataExportOrderResponse, err error) {
	response = CreateCreateDataExportOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataExportOrderWithChan invokes the dms_enterprise.CreateDataExportOrder API asynchronously
func (client *Client) CreateDataExportOrderWithChan(request *CreateDataExportOrderRequest) (<-chan *CreateDataExportOrderResponse, <-chan error) {
	responseChan := make(chan *CreateDataExportOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataExportOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataExportOrderWithCallback invokes the dms_enterprise.CreateDataExportOrder API asynchronously
func (client *Client) CreateDataExportOrderWithCallback(request *CreateDataExportOrderRequest, callback func(response *CreateDataExportOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataExportOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateDataExportOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataExportOrderRequest is the request struct for api CreateDataExportOrder
type CreateDataExportOrderRequest struct {
	*requests.RpcRequest
	ParentId         requests.Integer                 `position:"Query" name:"ParentId"`
	Tid              requests.Integer                 `position:"Query" name:"Tid"`
	RelatedUserList  *[]string                        `position:"Query" name:"RelatedUserList"  type:"Json"`
	PluginParam      CreateDataExportOrderPluginParam `position:"Query" name:"PluginParam"  type:"Struct"`
	RealLoginUserUid string                           `position:"Query" name:"RealLoginUserUid"`
	AttachmentKey    string                           `position:"Query" name:"AttachmentKey"`
	Comment          string                           `position:"Query" name:"Comment"`
}

// CreateDataExportOrderPluginParam is a repeated param struct in CreateDataExportOrderRequest
type CreateDataExportOrderPluginParam struct {
	Classify               string                                    `name:"Classify"`
	AffectRows             string                                    `name:"AffectRows"`
	InstanceId             string                                    `name:"InstanceId"`
	Watermark              CreateDataExportOrderPluginParamWatermark `name:"Watermark" type:"Struct"`
	DbId                   string                                    `name:"DbId"`
	ExeSQL                 string                                    `name:"ExeSQL"`
	IgnoreAffectRowsReason string                                    `name:"IgnoreAffectRowsReason"`
	Logic                  string                                    `name:"Logic"`
	IgnoreAffectRows       string                                    `name:"IgnoreAffectRows"`
}

// CreateDataExportOrderPluginParamWatermark is a repeated param struct in CreateDataExportOrderRequest
type CreateDataExportOrderPluginParamWatermark struct {
	DataWatermark  string    `name:"DataWatermark"`
	FileWatermark  string    `name:"FileWatermark"`
	Keys           *[]string `name:"Keys" type:"Repeated"`
	WatermarkTypes *[]string `name:"WatermarkTypes" type:"Repeated"`
	ColumnName     string    `name:"ColumnName"`
}

// CreateDataExportOrderResponse is the response struct for api CreateDataExportOrder
type CreateDataExportOrderResponse struct {
	*responses.BaseResponse
	RequestId         string                                   `json:"RequestId" xml:"RequestId"`
	ErrorCode         string                                   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage      string                                   `json:"ErrorMessage" xml:"ErrorMessage"`
	Success           bool                                     `json:"Success" xml:"Success"`
	CreateOrderResult CreateOrderResultInCreateDataExportOrder `json:"CreateOrderResult" xml:"CreateOrderResult"`
}

// CreateCreateDataExportOrderRequest creates a request to invoke CreateDataExportOrder API
func CreateCreateDataExportOrderRequest() (request *CreateDataExportOrderRequest) {
	request = &CreateDataExportOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateDataExportOrder", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDataExportOrderResponse creates a response to parse from CreateDataExportOrder response
func CreateCreateDataExportOrderResponse() (response *CreateDataExportOrderResponse) {
	response = &CreateDataExportOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
