package dms_dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopGateway invokes the dms_dg.StopGateway API synchronously
func (client *Client) StopGateway(request *StopGatewayRequest) (response *StopGatewayResponse, err error) {
	response = CreateStopGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// StopGatewayWithChan invokes the dms_dg.StopGateway API asynchronously
func (client *Client) StopGatewayWithChan(request *StopGatewayRequest) (<-chan *StopGatewayResponse, <-chan error) {
	responseChan := make(chan *StopGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopGatewayWithCallback invokes the dms_dg.StopGateway API asynchronously
func (client *Client) StopGatewayWithCallback(request *StopGatewayRequest, callback func(response *StopGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopGatewayResponse
		var err error
		defer close(result)
		response, err = client.StopGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopGatewayRequest is the request struct for api StopGateway
type StopGatewayRequest struct {
	*requests.RpcRequest
	GatewayInstanceId string `position:"Body" name:"GatewayInstanceId"`
	GatewayId         string `position:"Body" name:"GatewayId"`
}

// StopGatewayResponse is the response struct for api StopGateway
type StopGatewayResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateStopGatewayRequest creates a request to invoke StopGateway API
func CreateStopGatewayRequest() (request *StopGatewayRequest) {
	request = &StopGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-dg", "2023-09-14", "StopGateway", "", "")
	request.Method = requests.POST
	return
}

// CreateStopGatewayResponse creates a response to parse from StopGateway response
func CreateStopGatewayResponse() (response *StopGatewayResponse) {
	response = &StopGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
