package dms_dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGatewayVerifyCode invokes the dms_dg.CreateGatewayVerifyCode API synchronously
func (client *Client) CreateGatewayVerifyCode(request *CreateGatewayVerifyCodeRequest) (response *CreateGatewayVerifyCodeResponse, err error) {
	response = CreateCreateGatewayVerifyCodeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewayVerifyCodeWithChan invokes the dms_dg.CreateGatewayVerifyCode API asynchronously
func (client *Client) CreateGatewayVerifyCodeWithChan(request *CreateGatewayVerifyCodeRequest) (<-chan *CreateGatewayVerifyCodeResponse, <-chan error) {
	responseChan := make(chan *CreateGatewayVerifyCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGatewayVerifyCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewayVerifyCodeWithCallback invokes the dms_dg.CreateGatewayVerifyCode API asynchronously
func (client *Client) CreateGatewayVerifyCodeWithCallback(request *CreateGatewayVerifyCodeRequest, callback func(response *CreateGatewayVerifyCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewayVerifyCodeResponse
		var err error
		defer close(result)
		response, err = client.CreateGatewayVerifyCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewayVerifyCodeRequest is the request struct for api CreateGatewayVerifyCode
type CreateGatewayVerifyCodeRequest struct {
	*requests.RpcRequest
	GatewayId string `position:"Body" name:"GatewayId"`
}

// CreateGatewayVerifyCodeResponse is the response struct for api CreateGatewayVerifyCode
type CreateGatewayVerifyCodeResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateGatewayVerifyCodeRequest creates a request to invoke CreateGatewayVerifyCode API
func CreateCreateGatewayVerifyCodeRequest() (request *CreateGatewayVerifyCodeRequest) {
	request = &CreateGatewayVerifyCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-dg", "2023-09-14", "CreateGatewayVerifyCode", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateGatewayVerifyCodeResponse creates a response to parse from CreateGatewayVerifyCode response
func CreateCreateGatewayVerifyCodeResponse() (response *CreateGatewayVerifyCodeResponse) {
	response = &CreateGatewayVerifyCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
