package dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGatewayInstance invokes the dg.DeleteGatewayInstance API synchronously
func (client *Client) DeleteGatewayInstance(request *DeleteGatewayInstanceRequest) (response *DeleteGatewayInstanceResponse, err error) {
	response = CreateDeleteGatewayInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGatewayInstanceWithChan invokes the dg.DeleteGatewayInstance API asynchronously
func (client *Client) DeleteGatewayInstanceWithChan(request *DeleteGatewayInstanceRequest) (<-chan *DeleteGatewayInstanceResponse, <-chan error) {
	responseChan := make(chan *DeleteGatewayInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGatewayInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGatewayInstanceWithCallback invokes the dg.DeleteGatewayInstance API asynchronously
func (client *Client) DeleteGatewayInstanceWithCallback(request *DeleteGatewayInstanceRequest, callback func(response *DeleteGatewayInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGatewayInstanceResponse
		var err error
		defer close(result)
		response, err = client.DeleteGatewayInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGatewayInstanceRequest is the request struct for api DeleteGatewayInstance
type DeleteGatewayInstanceRequest struct {
	*requests.RpcRequest
	GatewayInstanceId string `position:"Body" name:"GatewayInstanceId"`
	GatewayId         string `position:"Body" name:"GatewayId"`
}

// DeleteGatewayInstanceResponse is the response struct for api DeleteGatewayInstance
type DeleteGatewayInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDeleteGatewayInstanceRequest creates a request to invoke DeleteGatewayInstance API
func CreateDeleteGatewayInstanceRequest() (request *DeleteGatewayInstanceRequest) {
	request = &DeleteGatewayInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dg", "2019-03-27", "DeleteGatewayInstance", "dg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteGatewayInstanceResponse creates a response to parse from DeleteGatewayInstance response
func CreateDeleteGatewayInstanceResponse() (response *DeleteGatewayInstanceResponse) {
	response = &DeleteGatewayInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
