package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMountPoint invokes the dfs.ModifyMountPoint API synchronously
func (client *Client) ModifyMountPoint(request *ModifyMountPointRequest) (response *ModifyMountPointResponse, err error) {
	response = CreateModifyMountPointResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMountPointWithChan invokes the dfs.ModifyMountPoint API asynchronously
func (client *Client) ModifyMountPointWithChan(request *ModifyMountPointRequest) (<-chan *ModifyMountPointResponse, <-chan error) {
	responseChan := make(chan *ModifyMountPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMountPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMountPointWithCallback invokes the dfs.ModifyMountPoint API asynchronously
func (client *Client) ModifyMountPointWithCallback(request *ModifyMountPointRequest, callback func(response *ModifyMountPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMountPointResponse
		var err error
		defer close(result)
		response, err = client.ModifyMountPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMountPointRequest is the request struct for api ModifyMountPoint
type ModifyMountPointRequest struct {
	*requests.RpcRequest
	Description   string `position:"Query" name:"Description"`
	AccessGroupId string `position:"Query" name:"AccessGroupId"`
	InputRegionId string `position:"Query" name:"InputRegionId"`
	MountPointId  string `position:"Query" name:"MountPointId"`
	FileSystemId  string `position:"Query" name:"FileSystemId"`
	Status        string `position:"Query" name:"Status"`
}

// ModifyMountPointResponse is the response struct for api ModifyMountPoint
type ModifyMountPointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyMountPointRequest creates a request to invoke ModifyMountPoint API
func CreateModifyMountPointRequest() (request *ModifyMountPointRequest) {
	request = &ModifyMountPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "ModifyMountPoint", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyMountPointResponse creates a response to parse from ModifyMountPoint response
func CreateModifyMountPointResponse() (response *ModifyMountPointResponse) {
	response = &ModifyMountPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
