package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserGroupsMappings invokes the dfs.ListUserGroupsMappings API synchronously
func (client *Client) ListUserGroupsMappings(request *ListUserGroupsMappingsRequest) (response *ListUserGroupsMappingsResponse, err error) {
	response = CreateListUserGroupsMappingsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserGroupsMappingsWithChan invokes the dfs.ListUserGroupsMappings API asynchronously
func (client *Client) ListUserGroupsMappingsWithChan(request *ListUserGroupsMappingsRequest) (<-chan *ListUserGroupsMappingsResponse, <-chan error) {
	responseChan := make(chan *ListUserGroupsMappingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserGroupsMappings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserGroupsMappingsWithCallback invokes the dfs.ListUserGroupsMappings API asynchronously
func (client *Client) ListUserGroupsMappingsWithCallback(request *ListUserGroupsMappingsRequest, callback func(response *ListUserGroupsMappingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserGroupsMappingsResponse
		var err error
		defer close(result)
		response, err = client.ListUserGroupsMappings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserGroupsMappingsRequest is the request struct for api ListUserGroupsMappings
type ListUserGroupsMappingsRequest struct {
	*requests.RpcRequest
	NextToken     string           `position:"Query" name:"NextToken"`
	InputRegionId string           `position:"Query" name:"InputRegionId"`
	Limit         requests.Integer `position:"Query" name:"Limit"`
	FilesystemId  string           `position:"Query" name:"FilesystemId"`
}

// ListUserGroupsMappingsResponse is the response struct for api ListUserGroupsMappings
type ListUserGroupsMappingsResponse struct {
	*responses.BaseResponse
	RequestId          string                `json:"RequestId" xml:"RequestId"`
	HasMore            bool                  `json:"HasMore" xml:"HasMore"`
	NextToken          string                `json:"NextToken" xml:"NextToken"`
	UserGroupsMappings []UserGroupsMappingPB `json:"UserGroupsMappings" xml:"UserGroupsMappings"`
}

// CreateListUserGroupsMappingsRequest creates a request to invoke ListUserGroupsMappings API
func CreateListUserGroupsMappingsRequest() (request *ListUserGroupsMappingsRequest) {
	request = &ListUserGroupsMappingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "ListUserGroupsMappings", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListUserGroupsMappingsResponse creates a response to parse from ListUserGroupsMappings response
func CreateListUserGroupsMappingsResponse() (response *ListUserGroupsMappingsResponse) {
	response = &ListUserGroupsMappingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
