package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVscMountPoint invokes the dfs.DeleteVscMountPoint API synchronously
func (client *Client) DeleteVscMountPoint(request *DeleteVscMountPointRequest) (response *DeleteVscMountPointResponse, err error) {
	response = CreateDeleteVscMountPointResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVscMountPointWithChan invokes the dfs.DeleteVscMountPoint API asynchronously
func (client *Client) DeleteVscMountPointWithChan(request *DeleteVscMountPointRequest) (<-chan *DeleteVscMountPointResponse, <-chan error) {
	responseChan := make(chan *DeleteVscMountPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVscMountPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVscMountPointWithCallback invokes the dfs.DeleteVscMountPoint API asynchronously
func (client *Client) DeleteVscMountPointWithCallback(request *DeleteVscMountPointRequest, callback func(response *DeleteVscMountPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVscMountPointResponse
		var err error
		defer close(result)
		response, err = client.DeleteVscMountPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVscMountPointRequest is the request struct for api DeleteVscMountPoint
type DeleteVscMountPointRequest struct {
	*requests.RpcRequest
	InputRegionId string `position:"Query" name:"InputRegionId"`
	MountPointId  string `position:"Query" name:"MountPointId"`
	FileSystemId  string `position:"Query" name:"FileSystemId"`
}

// DeleteVscMountPointResponse is the response struct for api DeleteVscMountPoint
type DeleteVscMountPointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVscMountPointRequest creates a request to invoke DeleteVscMountPoint API
func CreateDeleteVscMountPointRequest() (request *DeleteVscMountPointRequest) {
	request = &DeleteVscMountPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "DeleteVscMountPoint", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVscMountPointResponse creates a response to parse from DeleteVscMountPoint response
func CreateDeleteVscMountPointResponse() (response *DeleteVscMountPointResponse) {
	response = &DeleteVscMountPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
