package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDevopsProjectTask invokes the devops_rdc.UpdateDevopsProjectTask API synchronously
func (client *Client) UpdateDevopsProjectTask(request *UpdateDevopsProjectTaskRequest) (response *UpdateDevopsProjectTaskResponse, err error) {
	response = CreateUpdateDevopsProjectTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDevopsProjectTaskWithChan invokes the devops_rdc.UpdateDevopsProjectTask API asynchronously
func (client *Client) UpdateDevopsProjectTaskWithChan(request *UpdateDevopsProjectTaskRequest) (<-chan *UpdateDevopsProjectTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateDevopsProjectTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDevopsProjectTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDevopsProjectTaskWithCallback invokes the devops_rdc.UpdateDevopsProjectTask API asynchronously
func (client *Client) UpdateDevopsProjectTaskWithCallback(request *UpdateDevopsProjectTaskRequest, callback func(response *UpdateDevopsProjectTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDevopsProjectTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateDevopsProjectTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDevopsProjectTaskRequest is the request struct for api UpdateDevopsProjectTask
type UpdateDevopsProjectTaskRequest struct {
	*requests.RpcRequest
	Note                   string           `position:"Body" name:"Note"`
	Visible                string           `position:"Body" name:"Visible"`
	ExecutorId             string           `position:"Body" name:"ExecutorId"`
	TaskFlowStatusId       string           `position:"Body" name:"TaskFlowStatusId"`
	ScenarioFiieldConfigId string           `position:"Body" name:"ScenarioFiieldConfigId"`
	StartDate              string           `position:"Body" name:"StartDate"`
	Priority               requests.Integer `position:"Body" name:"Priority"`
	ParentTaskId           string           `position:"Body" name:"ParentTaskId"`
	OrgId                  string           `position:"Body" name:"OrgId"`
	Content                string           `position:"Body" name:"Content"`
	SprintId               string           `position:"Body" name:"SprintId"`
	DueDate                string           `position:"Body" name:"DueDate"`
	ProjectId              string           `position:"Body" name:"ProjectId"`
	TaskId                 string           `position:"Body" name:"TaskId"`
}

// UpdateDevopsProjectTaskResponse is the response struct for api UpdateDevopsProjectTask
type UpdateDevopsProjectTaskResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     bool   `json:"Object" xml:"Object"`
}

// CreateUpdateDevopsProjectTaskRequest creates a request to invoke UpdateDevopsProjectTask API
func CreateUpdateDevopsProjectTaskRequest() (request *UpdateDevopsProjectTaskRequest) {
	request = &UpdateDevopsProjectTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "UpdateDevopsProjectTask", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDevopsProjectTaskResponse creates a response to parse from UpdateDevopsProjectTask response
func CreateUpdateDevopsProjectTaskResponse() (response *UpdateDevopsProjectTaskResponse) {
	response = &UpdateDevopsProjectTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
