package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyBizBandWidthMode invokes the ddoscoo.ModifyBizBandWidthMode API synchronously
func (client *Client) ModifyBizBandWidthMode(request *ModifyBizBandWidthModeRequest) (response *ModifyBizBandWidthModeResponse, err error) {
	response = CreateModifyBizBandWidthModeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyBizBandWidthModeWithChan invokes the ddoscoo.ModifyBizBandWidthMode API asynchronously
func (client *Client) ModifyBizBandWidthModeWithChan(request *ModifyBizBandWidthModeRequest) (<-chan *ModifyBizBandWidthModeResponse, <-chan error) {
	responseChan := make(chan *ModifyBizBandWidthModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyBizBandWidthMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyBizBandWidthModeWithCallback invokes the ddoscoo.ModifyBizBandWidthMode API asynchronously
func (client *Client) ModifyBizBandWidthModeWithCallback(request *ModifyBizBandWidthModeRequest, callback func(response *ModifyBizBandWidthModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyBizBandWidthModeResponse
		var err error
		defer close(result)
		response, err = client.ModifyBizBandWidthMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyBizBandWidthModeRequest is the request struct for api ModifyBizBandWidthMode
type ModifyBizBandWidthModeRequest struct {
	*requests.RpcRequest
	Mode       string `position:"Query" name:"Mode"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ModifyBizBandWidthModeResponse is the response struct for api ModifyBizBandWidthMode
type ModifyBizBandWidthModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyBizBandWidthModeRequest creates a request to invoke ModifyBizBandWidthMode API
func CreateModifyBizBandWidthModeRequest() (request *ModifyBizBandWidthModeRequest) {
	request = &ModifyBizBandWidthModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyBizBandWidthMode", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyBizBandWidthModeResponse creates a response to parse from ModifyBizBandWidthMode response
func CreateModifyBizBandWidthModeResponse() (response *ModifyBizBandWidthModeResponse) {
	response = &ModifyBizBandWidthModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
