package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePortViewSourceProvinces invokes the ddoscoo.DescribePortViewSourceProvinces API synchronously
func (client *Client) DescribePortViewSourceProvinces(request *DescribePortViewSourceProvincesRequest) (response *DescribePortViewSourceProvincesResponse, err error) {
	response = CreateDescribePortViewSourceProvincesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePortViewSourceProvincesWithChan invokes the ddoscoo.DescribePortViewSourceProvinces API asynchronously
func (client *Client) DescribePortViewSourceProvincesWithChan(request *DescribePortViewSourceProvincesRequest) (<-chan *DescribePortViewSourceProvincesResponse, <-chan error) {
	responseChan := make(chan *DescribePortViewSourceProvincesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePortViewSourceProvinces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePortViewSourceProvincesWithCallback invokes the ddoscoo.DescribePortViewSourceProvinces API asynchronously
func (client *Client) DescribePortViewSourceProvincesWithCallback(request *DescribePortViewSourceProvincesRequest, callback func(response *DescribePortViewSourceProvincesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePortViewSourceProvincesResponse
		var err error
		defer close(result)
		response, err = client.DescribePortViewSourceProvinces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePortViewSourceProvincesRequest is the request struct for api DescribePortViewSourceProvinces
type DescribePortViewSourceProvincesRequest struct {
	*requests.RpcRequest
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// DescribePortViewSourceProvincesResponse is the response struct for api DescribePortViewSourceProvinces
type DescribePortViewSourceProvincesResponse struct {
	*responses.BaseResponse
	RequestId       string     `json:"RequestId" xml:"RequestId"`
	SourceProvinces []Province `json:"SourceProvinces" xml:"SourceProvinces"`
}

// CreateDescribePortViewSourceProvincesRequest creates a request to invoke DescribePortViewSourceProvinces API
func CreateDescribePortViewSourceProvincesRequest() (request *DescribePortViewSourceProvincesRequest) {
	request = &DescribePortViewSourceProvincesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribePortViewSourceProvinces", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePortViewSourceProvincesResponse creates a response to parse from DescribePortViewSourceProvinces response
func CreateDescribePortViewSourceProvincesResponse() (response *DescribePortViewSourceProvincesResponse) {
	response = &DescribePortViewSourceProvincesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
