package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDcdnKv invokes the dcdn.ListDcdnKv API synchronously
func (client *Client) ListDcdnKv(request *ListDcdnKvRequest) (response *ListDcdnKvResponse, err error) {
	response = CreateListDcdnKvResponse()
	err = client.DoAction(request, response)
	return
}

// ListDcdnKvWithChan invokes the dcdn.ListDcdnKv API asynchronously
func (client *Client) ListDcdnKvWithChan(request *ListDcdnKvRequest) (<-chan *ListDcdnKvResponse, <-chan error) {
	responseChan := make(chan *ListDcdnKvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDcdnKv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDcdnKvWithCallback invokes the dcdn.ListDcdnKv API asynchronously
func (client *Client) ListDcdnKvWithCallback(request *ListDcdnKvRequest, callback func(response *ListDcdnKvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDcdnKvResponse
		var err error
		defer close(result)
		response, err = client.ListDcdnKv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDcdnKvRequest is the request struct for api ListDcdnKv
type ListDcdnKvRequest struct {
	*requests.RpcRequest
	Prefix     string           `position:"Query" name:"Prefix"`
	Namespace  string           `position:"Query" name:"Namespace"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListDcdnKvResponse is the response struct for api ListDcdnKv
type ListDcdnKvResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	Keys       []Key  `json:"Keys" xml:"Keys"`
}

// CreateListDcdnKvRequest creates a request to invoke ListDcdnKv API
func CreateListDcdnKvRequest() (request *ListDcdnKvRequest) {
	request = &ListDcdnKvRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "ListDcdnKv", "", "")
	request.Method = requests.GET
	return
}

// CreateListDcdnKvResponse creates a response to parse from ListDcdnKv response
func CreateListDcdnKvResponse() (response *ListDcdnKvResponse) {
	response = &ListDcdnKvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
