package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDcdnKvStatus invokes the dcdn.GetDcdnKvStatus API synchronously
func (client *Client) GetDcdnKvStatus(request *GetDcdnKvStatusRequest) (response *GetDcdnKvStatusResponse, err error) {
	response = CreateGetDcdnKvStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetDcdnKvStatusWithChan invokes the dcdn.GetDcdnKvStatus API asynchronously
func (client *Client) GetDcdnKvStatusWithChan(request *GetDcdnKvStatusRequest) (<-chan *GetDcdnKvStatusResponse, <-chan error) {
	responseChan := make(chan *GetDcdnKvStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDcdnKvStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDcdnKvStatusWithCallback invokes the dcdn.GetDcdnKvStatus API asynchronously
func (client *Client) GetDcdnKvStatusWithCallback(request *GetDcdnKvStatusRequest, callback func(response *GetDcdnKvStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDcdnKvStatusResponse
		var err error
		defer close(result)
		response, err = client.GetDcdnKvStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDcdnKvStatusRequest is the request struct for api GetDcdnKvStatus
type GetDcdnKvStatusRequest struct {
	*requests.RpcRequest
	Namespace string `position:"Query" name:"Namespace"`
	Key       string `position:"Query" name:"Key"`
}

// GetDcdnKvStatusResponse is the response struct for api GetDcdnKvStatus
type GetDcdnKvStatusResponse struct {
	*responses.BaseResponse
	Complete  bool   `json:"Complete" xml:"Complete"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Expire    string `json:"Expire" xml:"Expire"`
}

// CreateGetDcdnKvStatusRequest creates a request to invoke GetDcdnKvStatus API
func CreateGetDcdnKvStatusRequest() (request *GetDcdnKvStatusRequest) {
	request = &GetDcdnKvStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "GetDcdnKvStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDcdnKvStatusResponse creates a response to parse from GetDcdnKvStatus response
func CreateGetDcdnKvStatusResponse() (response *GetDcdnKvStatusResponse) {
	response = &GetDcdnKvStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
