package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafGeoInfo invokes the dcdn.DescribeDcdnWafGeoInfo API synchronously
func (client *Client) DescribeDcdnWafGeoInfo(request *DescribeDcdnWafGeoInfoRequest) (response *DescribeDcdnWafGeoInfoResponse, err error) {
	response = CreateDescribeDcdnWafGeoInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafGeoInfoWithChan invokes the dcdn.DescribeDcdnWafGeoInfo API asynchronously
func (client *Client) DescribeDcdnWafGeoInfoWithChan(request *DescribeDcdnWafGeoInfoRequest) (<-chan *DescribeDcdnWafGeoInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafGeoInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafGeoInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafGeoInfoWithCallback invokes the dcdn.DescribeDcdnWafGeoInfo API asynchronously
func (client *Client) DescribeDcdnWafGeoInfoWithCallback(request *DescribeDcdnWafGeoInfoRequest, callback func(response *DescribeDcdnWafGeoInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafGeoInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafGeoInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafGeoInfoRequest is the request struct for api DescribeDcdnWafGeoInfo
type DescribeDcdnWafGeoInfoRequest struct {
	*requests.RpcRequest
	Language string `position:"Query" name:"Language"`
}

// DescribeDcdnWafGeoInfoResponse is the response struct for api DescribeDcdnWafGeoInfo
type DescribeDcdnWafGeoInfoResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Content   []GeoInfo `json:"Content" xml:"Content"`
}

// CreateDescribeDcdnWafGeoInfoRequest creates a request to invoke DescribeDcdnWafGeoInfo API
func CreateDescribeDcdnWafGeoInfoRequest() (request *DescribeDcdnWafGeoInfoRequest) {
	request = &DescribeDcdnWafGeoInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafGeoInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafGeoInfoResponse creates a response to parse from DescribeDcdnWafGeoInfo response
func CreateDescribeDcdnWafGeoInfoResponse() (response *DescribeDcdnWafGeoInfoResponse) {
	response = &DescribeDcdnWafGeoInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
