package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnUserVipsByDomain invokes the dcdn.DescribeDcdnUserVipsByDomain API synchronously
func (client *Client) DescribeDcdnUserVipsByDomain(request *DescribeDcdnUserVipsByDomainRequest) (response *DescribeDcdnUserVipsByDomainResponse, err error) {
	response = CreateDescribeDcdnUserVipsByDomainResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnUserVipsByDomainWithChan invokes the dcdn.DescribeDcdnUserVipsByDomain API asynchronously
func (client *Client) DescribeDcdnUserVipsByDomainWithChan(request *DescribeDcdnUserVipsByDomainRequest) (<-chan *DescribeDcdnUserVipsByDomainResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnUserVipsByDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnUserVipsByDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnUserVipsByDomainWithCallback invokes the dcdn.DescribeDcdnUserVipsByDomain API asynchronously
func (client *Client) DescribeDcdnUserVipsByDomainWithCallback(request *DescribeDcdnUserVipsByDomainRequest, callback func(response *DescribeDcdnUserVipsByDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnUserVipsByDomainResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnUserVipsByDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnUserVipsByDomainRequest is the request struct for api DescribeDcdnUserVipsByDomain
type DescribeDcdnUserVipsByDomainRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	Available  string `position:"Query" name:"Available"`
}

// DescribeDcdnUserVipsByDomainResponse is the response struct for api DescribeDcdnUserVipsByDomain
type DescribeDcdnUserVipsByDomainResponse struct {
	*responses.BaseResponse
	DomainName string                             `json:"DomainName" xml:"DomainName"`
	RequestId  string                             `json:"RequestId" xml:"RequestId"`
	Vips       VipsInDescribeDcdnUserVipsByDomain `json:"Vips" xml:"Vips"`
}

// CreateDescribeDcdnUserVipsByDomainRequest creates a request to invoke DescribeDcdnUserVipsByDomain API
func CreateDescribeDcdnUserVipsByDomainRequest() (request *DescribeDcdnUserVipsByDomainRequest) {
	request = &DescribeDcdnUserVipsByDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnUserVipsByDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnUserVipsByDomainResponse creates a response to parse from DescribeDcdnUserVipsByDomain response
func CreateDescribeDcdnUserVipsByDomainResponse() (response *DescribeDcdnUserVipsByDomainResponse) {
	response = &DescribeDcdnUserVipsByDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
