package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnUserSecDrop invokes the dcdn.DescribeDcdnUserSecDrop API synchronously
func (client *Client) DescribeDcdnUserSecDrop(request *DescribeDcdnUserSecDropRequest) (response *DescribeDcdnUserSecDropResponse, err error) {
	response = CreateDescribeDcdnUserSecDropResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnUserSecDropWithChan invokes the dcdn.DescribeDcdnUserSecDrop API asynchronously
func (client *Client) DescribeDcdnUserSecDropWithChan(request *DescribeDcdnUserSecDropRequest) (<-chan *DescribeDcdnUserSecDropResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnUserSecDropResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnUserSecDrop(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnUserSecDropWithCallback invokes the dcdn.DescribeDcdnUserSecDrop API asynchronously
func (client *Client) DescribeDcdnUserSecDropWithCallback(request *DescribeDcdnUserSecDropRequest, callback func(response *DescribeDcdnUserSecDropResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnUserSecDropResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnUserSecDrop(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnUserSecDropRequest is the request struct for api DescribeDcdnUserSecDrop
type DescribeDcdnUserSecDropRequest struct {
	*requests.RpcRequest
	Data    string `position:"Query" name:"Data"`
	Metric  string `position:"Query" name:"Metric"`
	SecFunc string `position:"Query" name:"SecFunc"`
}

// DescribeDcdnUserSecDropResponse is the response struct for api DescribeDcdnUserSecDrop
type DescribeDcdnUserSecDropResponse struct {
	*responses.BaseResponse
	Msg       string `json:"Msg" xml:"Msg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Drops     int    `json:"Drops" xml:"Drops"`
	UuidStr   string `json:"UuidStr" xml:"UuidStr"`
}

// CreateDescribeDcdnUserSecDropRequest creates a request to invoke DescribeDcdnUserSecDrop API
func CreateDescribeDcdnUserSecDropRequest() (request *DescribeDcdnUserSecDropRequest) {
	request = &DescribeDcdnUserSecDropRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnUserSecDrop", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnUserSecDropResponse creates a response to parse from DescribeDcdnUserSecDrop response
func CreateDescribeDcdnUserSecDropResponse() (response *DescribeDcdnUserSecDropResponse) {
	response = &DescribeDcdnUserSecDropResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
