package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDbfs invokes the dbfs.DeleteDbfs API synchronously
func (client *Client) DeleteDbfs(request *DeleteDbfsRequest) (response *DeleteDbfsResponse, err error) {
	response = CreateDeleteDbfsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDbfsWithChan invokes the dbfs.DeleteDbfs API asynchronously
func (client *Client) DeleteDbfsWithChan(request *DeleteDbfsRequest) (<-chan *DeleteDbfsResponse, <-chan error) {
	responseChan := make(chan *DeleteDbfsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDbfs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDbfsWithCallback invokes the dbfs.DeleteDbfs API asynchronously
func (client *Client) DeleteDbfsWithCallback(request *DeleteDbfsRequest, callback func(response *DeleteDbfsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDbfsResponse
		var err error
		defer close(result)
		response, err = client.DeleteDbfs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDbfsRequest is the request struct for api DeleteDbfs
type DeleteDbfsRequest struct {
	*requests.RpcRequest
	FsId  string           `position:"Query" name:"FsId"`
	Force requests.Boolean `position:"Query" name:"Force"`
}

// DeleteDbfsResponse is the response struct for api DeleteDbfs
type DeleteDbfsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDbfsRequest creates a request to invoke DeleteDbfs API
func CreateDeleteDbfsRequest() (request *DeleteDbfsRequest) {
	request = &DeleteDbfsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "DeleteDbfs", "dbfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDbfsResponse creates a response to parse from DeleteDbfs response
func CreateDeleteDbfsResponse() (response *DeleteDbfsResponse) {
	response = &DeleteDbfsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
