package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBusiness invokes the dataworks_public.UpdateBusiness API synchronously
func (client *Client) UpdateBusiness(request *UpdateBusinessRequest) (response *UpdateBusinessResponse, err error) {
	response = CreateUpdateBusinessResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBusinessWithChan invokes the dataworks_public.UpdateBusiness API asynchronously
func (client *Client) UpdateBusinessWithChan(request *UpdateBusinessRequest) (<-chan *UpdateBusinessResponse, <-chan error) {
	responseChan := make(chan *UpdateBusinessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBusiness(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBusinessWithCallback invokes the dataworks_public.UpdateBusiness API asynchronously
func (client *Client) UpdateBusinessWithCallback(request *UpdateBusinessRequest, callback func(response *UpdateBusinessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBusinessResponse
		var err error
		defer close(result)
		response, err = client.UpdateBusiness(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBusinessRequest is the request struct for api UpdateBusiness
type UpdateBusinessRequest struct {
	*requests.RpcRequest
	Owner             string           `position:"Body" name:"Owner"`
	BusinessId        requests.Integer `position:"Body" name:"BusinessId"`
	Description       string           `position:"Body" name:"Description"`
	ProjectIdentifier string           `position:"Body" name:"ProjectIdentifier"`
	BusinessName      string           `position:"Body" name:"BusinessName"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
}

// UpdateBusinessResponse is the response struct for api UpdateBusiness
type UpdateBusinessResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateBusinessRequest creates a request to invoke UpdateBusiness API
func CreateUpdateBusinessRequest() (request *UpdateBusinessRequest) {
	request = &UpdateBusinessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateBusiness", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateBusinessResponse creates a response to parse from UpdateBusiness response
func CreateUpdateBusinessResponse() (response *UpdateBusinessResponse) {
	response = &UpdateBusinessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
