package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRecognizeRulesType invokes the dataworks_public.QueryRecognizeRulesType API synchronously
func (client *Client) QueryRecognizeRulesType(request *QueryRecognizeRulesTypeRequest) (response *QueryRecognizeRulesTypeResponse, err error) {
	response = CreateQueryRecognizeRulesTypeResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRecognizeRulesTypeWithChan invokes the dataworks_public.QueryRecognizeRulesType API asynchronously
func (client *Client) QueryRecognizeRulesTypeWithChan(request *QueryRecognizeRulesTypeRequest) (<-chan *QueryRecognizeRulesTypeResponse, <-chan error) {
	responseChan := make(chan *QueryRecognizeRulesTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRecognizeRulesType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRecognizeRulesTypeWithCallback invokes the dataworks_public.QueryRecognizeRulesType API asynchronously
func (client *Client) QueryRecognizeRulesTypeWithCallback(request *QueryRecognizeRulesTypeRequest, callback func(response *QueryRecognizeRulesTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRecognizeRulesTypeResponse
		var err error
		defer close(result)
		response, err = client.QueryRecognizeRulesType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRecognizeRulesTypeRequest is the request struct for api QueryRecognizeRulesType
type QueryRecognizeRulesTypeRequest struct {
	*requests.RpcRequest
}

// QueryRecognizeRulesTypeResponse is the response struct for api QueryRecognizeRulesType
type QueryRecognizeRulesTypeResponse struct {
	*responses.BaseResponse
}

// CreateQueryRecognizeRulesTypeRequest creates a request to invoke QueryRecognizeRulesType API
func CreateQueryRecognizeRulesTypeRequest() (request *QueryRecognizeRulesTypeRequest) {
	request = &QueryRecognizeRulesTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "QueryRecognizeRulesType", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryRecognizeRulesTypeResponse creates a response to parse from QueryRecognizeRulesType response
func CreateQueryRecognizeRulesTypeResponse() (response *QueryRecognizeRulesTypeResponse) {
	response = &QueryRecognizeRulesTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
