package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMeasureData invokes the dataworks_public.ListMeasureData API synchronously
func (client *Client) ListMeasureData(request *ListMeasureDataRequest) (response *ListMeasureDataResponse, err error) {
	response = CreateListMeasureDataResponse()
	err = client.DoAction(request, response)
	return
}

// ListMeasureDataWithChan invokes the dataworks_public.ListMeasureData API asynchronously
func (client *Client) ListMeasureDataWithChan(request *ListMeasureDataRequest) (<-chan *ListMeasureDataResponse, <-chan error) {
	responseChan := make(chan *ListMeasureDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMeasureData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMeasureDataWithCallback invokes the dataworks_public.ListMeasureData API asynchronously
func (client *Client) ListMeasureDataWithCallback(request *ListMeasureDataRequest, callback func(response *ListMeasureDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMeasureDataResponse
		var err error
		defer close(result)
		response, err = client.ListMeasureData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMeasureDataRequest is the request struct for api ListMeasureData
type ListMeasureDataRequest struct {
	*requests.RpcRequest
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	DomainCode    string           `position:"Query" name:"DomainCode"`
	ComponentCode string           `position:"Query" name:"ComponentCode"`
}

// ListMeasureDataResponse is the response struct for api ListMeasureData
type ListMeasureDataResponse struct {
	*responses.BaseResponse
	RequestId      string        `json:"RequestId" xml:"RequestId"`
	Success        bool          `json:"Success" xml:"Success"`
	ErrorCode      string        `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string        `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	MeasureDatas   []MeasureData `json:"MeasureDatas" xml:"MeasureDatas"`
}

// CreateListMeasureDataRequest creates a request to invoke ListMeasureData API
func CreateListMeasureDataRequest() (request *ListMeasureDataRequest) {
	request = &ListMeasureDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListMeasureData", "", "")
	request.Method = requests.POST
	return
}

// CreateListMeasureDataResponse creates a response to parse from ListMeasureData response
func CreateListMeasureDataResponse() (response *ListMeasureDataResponse) {
	response = &ListMeasureDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
