package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgWhiteListQueryList invokes the dataworks_public.DsgWhiteListQueryList API synchronously
func (client *Client) DsgWhiteListQueryList(request *DsgWhiteListQueryListRequest) (response *DsgWhiteListQueryListResponse, err error) {
	response = CreateDsgWhiteListQueryListResponse()
	err = client.DoAction(request, response)
	return
}

// DsgWhiteListQueryListWithChan invokes the dataworks_public.DsgWhiteListQueryList API asynchronously
func (client *Client) DsgWhiteListQueryListWithChan(request *DsgWhiteListQueryListRequest) (<-chan *DsgWhiteListQueryListResponse, <-chan error) {
	responseChan := make(chan *DsgWhiteListQueryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgWhiteListQueryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgWhiteListQueryListWithCallback invokes the dataworks_public.DsgWhiteListQueryList API asynchronously
func (client *Client) DsgWhiteListQueryListWithCallback(request *DsgWhiteListQueryListRequest, callback func(response *DsgWhiteListQueryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgWhiteListQueryListResponse
		var err error
		defer close(result)
		response, err = client.DsgWhiteListQueryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgWhiteListQueryListRequest is the request struct for api DsgWhiteListQueryList
type DsgWhiteListQueryListRequest struct {
	*requests.RpcRequest
	DataType   string           `position:"Query" name:"DataType"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	SceneId    requests.Integer `position:"Query" name:"SceneId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DsgWhiteListQueryListResponse is the response struct for api DsgWhiteListQueryList
type DsgWhiteListQueryListResponse struct {
	*responses.BaseResponse
	Success        bool     `json:"Success" xml:"Success"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string   `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	PageData       PageData `json:"PageData" xml:"PageData"`
}

// CreateDsgWhiteListQueryListRequest creates a request to invoke DsgWhiteListQueryList API
func CreateDsgWhiteListQueryListRequest() (request *DsgWhiteListQueryListRequest) {
	request = &DsgWhiteListQueryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgWhiteListQueryList", "", "")
	request.Method = requests.GET
	return
}

// CreateDsgWhiteListQueryListResponse creates a response to parse from DsgWhiteListQueryList response
func CreateDsgWhiteListQueryListResponse() (response *DsgWhiteListQueryListResponse) {
	response = &DsgWhiteListQueryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
