package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateQueryOptimizeTag invokes the das.CreateQueryOptimizeTag API synchronously
func (client *Client) CreateQueryOptimizeTag(request *CreateQueryOptimizeTagRequest) (response *CreateQueryOptimizeTagResponse, err error) {
	response = CreateCreateQueryOptimizeTagResponse()
	err = client.DoAction(request, response)
	return
}

// CreateQueryOptimizeTagWithChan invokes the das.CreateQueryOptimizeTag API asynchronously
func (client *Client) CreateQueryOptimizeTagWithChan(request *CreateQueryOptimizeTagRequest) (<-chan *CreateQueryOptimizeTagResponse, <-chan error) {
	responseChan := make(chan *CreateQueryOptimizeTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateQueryOptimizeTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateQueryOptimizeTagWithCallback invokes the das.CreateQueryOptimizeTag API asynchronously
func (client *Client) CreateQueryOptimizeTagWithCallback(request *CreateQueryOptimizeTagRequest, callback func(response *CreateQueryOptimizeTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateQueryOptimizeTagResponse
		var err error
		defer close(result)
		response, err = client.CreateQueryOptimizeTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateQueryOptimizeTagRequest is the request struct for api CreateQueryOptimizeTag
type CreateQueryOptimizeTagRequest struct {
	*requests.RpcRequest
	ConsoleContext string           `position:"Query" name:"ConsoleContext"`
	Engine         string           `position:"Query" name:"Engine"`
	SqlIds         string           `position:"Query" name:"SqlIds"`
	Tags           string           `position:"Query" name:"Tags"`
	Status         requests.Integer `position:"Query" name:"Status"`
	Comments       string           `position:"Query" name:"Comments"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
}

// CreateQueryOptimizeTagResponse is the response struct for api CreateQueryOptimizeTag
type CreateQueryOptimizeTagResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCreateQueryOptimizeTagRequest creates a request to invoke CreateQueryOptimizeTag API
func CreateCreateQueryOptimizeTagRequest() (request *CreateQueryOptimizeTagRequest) {
	request = &CreateQueryOptimizeTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "CreateQueryOptimizeTag", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateQueryOptimizeTagResponse creates a response to parse from CreateQueryOptimizeTag response
func CreateCreateQueryOptimizeTagResponse() (response *CreateQueryOptimizeTagResponse) {
	response = &CreateQueryOptimizeTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
